#ifndef C64LIB_H
#define C64LIB_H

#define BLACK 0
#define WHITE 1
#define RED 2
#define CYAN 3
#define MAGENTA 4
#define GREEN 5
#define BLUE 6
#define YELLOW 7
#define ORANGE 8
#define BROWN 9
#define LIGHT_RED 10
#define DARK_GRAY 11
#define GRAY 12
#define LIGHT_GREEN 13
#define LIGHT_BLUE 14
#define LIGHT_GRAY 15

// Alternative names
#define PURPLE 4
#define PINK 10

// See: http://www.zimmers.net/anonftp/pub/cbm/maps/C64.MemoryMap

// Default settings only
#define CHAR_RAM 0x400
#define COLOR_RAM 0xd800
#define SPRITE_PTR 0x7f8

#define SPRITE_POS 0xd000 // first x (byte) then y (byte)
#define SPRITE_MSB 0xd010 // High bits of sprite x pos
#define SPRITE_DISPLAY 0xd015 // On or not?
#define SPRITE_EXPAND_Y 0xd017
#define SPRITE_EXPAND_X 0xd01d
#define SPRITE_COLOR 0xd027 // Individual sprite colors start here
#define SPRITE_MULTICOLOR 0xd01c // Whether multicolor or not
#define SPRITE_MULTICOLOR0 0xd025 // Multicolor colors for all sprites
#define SPRITE_MULTICOLOR1 0xd026
#define SPRITE_PRIORITY 0xd01b // 0 here = show sprite in front of chars

#define RASTER_POS 0xd012 // Read to get the CRT current line

#define VIC_CTR0 0xd011 // VIC control register with (and y scroll in 2-0):
#define VIC_EXTENDED_COLOR_MODE 0x40
#define VIC_BITMAP_MODE 0x20
#define VIC_BLANK 0x10
#define VIC_25_ROWS 0x8

#define VIC_CTR1 0xd016 // VIC control register with (and x scroll in 2-0):
#define VIC_MULTICOLOR_MODE 0x10
#define VIC_40_COLS 0x8	// 40 chars per row?

#define VIC_MEM 0xd018	// Base addresses of chars (7-4) and bitmap (3-1)

#define VIC_INT 0xd019 	// Interrupt flags

#define VIC_BORDER 0xd020 // Border color
#define VIC_COLOR 0xd021  // Background colors start here

#define DATA_A 0xdd00	// Data port A. 1-0: VIC bank number

#define SEI __asm__("sei")
#define CLI __asm__("cli")
#define waitline(x) while(*(unsigned char *)RASTER_POS!=x);

#endif
