import QtQuick 2.0
import Sailfish.Silica 1.0

Item
{
	property alias label: labelText.text
	property alias value: valueText.text
	property real leftMargin: Theme.horizontalPageMargin
	property real rightMargin: Theme.horizontalPageMargin

	id: detailItem
	width: parent.width
	height: Math.max(labelText.height, valueText.height) + 2 * Theme.paddingSmall

	Text
	{
		anchors
		{
			left: parent.left
			leftMargin: detailItem.leftMargin
		}

		font
		{
			pixelSize: Theme.fontSizeSmall
		}

		id: labelText
		y: Theme.paddingSmall
		color: Theme.secondaryHighlightColor
		textFormat: Text.PlainText
		wrapMode: Text.Wrap
	}

	Text
	{
		anchors
		{
			left: labelText.right
			right: parent.right
			leftMargin: Theme.paddingMedium
			rightMargin: detailItem.rightMargin
		}

		font
		{
			pixelSize: Theme.fontSizeSmall
		}

		id: valueText
		y: Theme.paddingSmall
		color: Theme.highlightColor
		textFormat: Text.PlainText
		wrapMode: Text.Wrap
	}
}
