/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.internal.zzaa;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;

public final class zzl
implements Handler.Callback {
    private final zza zzarI;
    private final ArrayList<GoogleApiClient.ConnectionCallbacks> zzarJ = new ArrayList();
    final ArrayList<GoogleApiClient.ConnectionCallbacks> zzarK = new ArrayList();
    private final ArrayList<GoogleApiClient.OnConnectionFailedListener> zzarL = new ArrayList();
    private volatile boolean zzarM = false;
    private final AtomicInteger zzarN = new AtomicInteger(0);
    private boolean zzarO = false;
    private final Handler mHandler;
    private final Object zzpp = new Object();

    public zzl(Looper looper, zza zza2) {
        this.zzarI = zza2;
        this.mHandler = new Handler(looper, (Handler.Callback)this);
    }

    public void zztI() {
        this.zzarM = false;
        this.zzarN.incrementAndGet();
    }

    public void zztJ() {
        this.zzarM = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzm(Bundle bundle) {
        zzaa.zza((Looper.myLooper() == this.mHandler.getLooper() ? 1 : 0) != 0, (Object)"onConnectionSuccess must only be called on the Handler thread");
        Object object = this.zzpp;
        synchronized (object) {
            zzaa.zzai((!this.zzarO ? 1 : 0) != 0);
            this.mHandler.removeMessages(1);
            this.zzarO = true;
            zzaa.zzai((this.zzarK.size() == 0 ? 1 : 0) != 0);
            ArrayList<GoogleApiClient.ConnectionCallbacks> arrayList = new ArrayList<GoogleApiClient.ConnectionCallbacks>(this.zzarJ);
            int n = this.zzarN.get();
            for (GoogleApiClient.ConnectionCallbacks connectionCallbacks : arrayList) {
                if (!this.zzarM || !this.zzarI.isConnected() || this.zzarN.get() != n) break;
                if (this.zzarK.contains(connectionCallbacks)) continue;
                connectionCallbacks.onConnected(bundle);
            }
            this.zzarK.clear();
            this.zzarO = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzcc(int n) {
        zzaa.zza((Looper.myLooper() == this.mHandler.getLooper() ? 1 : 0) != 0, (Object)"onUnintentionalDisconnection must only be called on the Handler thread");
        this.mHandler.removeMessages(1);
        Object object = this.zzpp;
        synchronized (object) {
            this.zzarO = true;
            ArrayList<GoogleApiClient.ConnectionCallbacks> arrayList = new ArrayList<GoogleApiClient.ConnectionCallbacks>(this.zzarJ);
            int n2 = this.zzarN.get();
            for (GoogleApiClient.ConnectionCallbacks connectionCallbacks : arrayList) {
                if (!this.zzarM || this.zzarN.get() != n2) break;
                if (!this.zzarJ.contains(connectionCallbacks)) continue;
                connectionCallbacks.onConnectionSuspended(n);
            }
            this.zzarK.clear();
            this.zzarO = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzm(ConnectionResult connectionResult) {
        zzaa.zza((Looper.myLooper() == this.mHandler.getLooper() ? 1 : 0) != 0, (Object)"onConnectionFailure must only be called on the Handler thread");
        this.mHandler.removeMessages(1);
        Object object = this.zzpp;
        synchronized (object) {
            ArrayList<GoogleApiClient.OnConnectionFailedListener> arrayList = new ArrayList<GoogleApiClient.OnConnectionFailedListener>(this.zzarL);
            int n = this.zzarN.get();
            for (GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener : arrayList) {
                if (!this.zzarM || this.zzarN.get() != n) {
                    return;
                }
                if (!this.zzarL.contains(onConnectionFailedListener)) continue;
                onConnectionFailedListener.onConnectionFailed(connectionResult);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerConnectionCallbacks(GoogleApiClient.ConnectionCallbacks connectionCallbacks) {
        zzaa.zzz((Object)connectionCallbacks);
        Object object = this.zzpp;
        synchronized (object) {
            if (this.zzarJ.contains(connectionCallbacks)) {
                String string2 = String.valueOf(connectionCallbacks);
                Log.w((String)"GmsClientEvents", (String)new StringBuilder(62 + String.valueOf(string2).length()).append("registerConnectionCallbacks(): listener ").append(string2).append(" is already registered").toString());
            } else {
                this.zzarJ.add(connectionCallbacks);
            }
        }
        if (this.zzarI.isConnected()) {
            this.mHandler.sendMessage(this.mHandler.obtainMessage(1, (Object)connectionCallbacks));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnectionCallbacksRegistered(GoogleApiClient.ConnectionCallbacks connectionCallbacks) {
        zzaa.zzz((Object)connectionCallbacks);
        Object object = this.zzpp;
        synchronized (object) {
            return this.zzarJ.contains(connectionCallbacks);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterConnectionCallbacks(GoogleApiClient.ConnectionCallbacks connectionCallbacks) {
        zzaa.zzz((Object)connectionCallbacks);
        Object object = this.zzpp;
        synchronized (object) {
            boolean bl = this.zzarJ.remove(connectionCallbacks);
            if (!bl) {
                String string2 = String.valueOf(connectionCallbacks);
                Log.w((String)"GmsClientEvents", (String)new StringBuilder(52 + String.valueOf(string2).length()).append("unregisterConnectionCallbacks(): listener ").append(string2).append(" not found").toString());
            } else if (this.zzarO) {
                this.zzarK.add(connectionCallbacks);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerConnectionFailedListener(GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        zzaa.zzz((Object)onConnectionFailedListener);
        Object object = this.zzpp;
        synchronized (object) {
            if (this.zzarL.contains(onConnectionFailedListener)) {
                String string2 = String.valueOf(onConnectionFailedListener);
                Log.w((String)"GmsClientEvents", (String)new StringBuilder(67 + String.valueOf(string2).length()).append("registerConnectionFailedListener(): listener ").append(string2).append(" is already registered").toString());
            } else {
                this.zzarL.add(onConnectionFailedListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnectionFailedListenerRegistered(GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        zzaa.zzz((Object)onConnectionFailedListener);
        Object object = this.zzpp;
        synchronized (object) {
            return this.zzarL.contains(onConnectionFailedListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterConnectionFailedListener(GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        zzaa.zzz((Object)onConnectionFailedListener);
        Object object = this.zzpp;
        synchronized (object) {
            boolean bl = this.zzarL.remove(onConnectionFailedListener);
            if (!bl) {
                String string2 = String.valueOf(onConnectionFailedListener);
                Log.w((String)"GmsClientEvents", (String)new StringBuilder(57 + String.valueOf(string2).length()).append("unregisterConnectionFailedListener(): listener ").append(string2).append(" not found").toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleMessage(Message message) {
        if (message.what == 1) {
            GoogleApiClient.ConnectionCallbacks connectionCallbacks = (GoogleApiClient.ConnectionCallbacks)message.obj;
            Object object = this.zzpp;
            synchronized (object) {
                if (this.zzarM && this.zzarI.isConnected() && this.zzarJ.contains(connectionCallbacks)) {
                    Bundle bundle = this.zzarI.zzqr();
                    connectionCallbacks.onConnected(bundle);
                }
            }
            return true;
        }
        int n = message.what;
        Log.wtf((String)"GmsClientEvents", (String)new StringBuilder(45).append("Don't know how to handle message: ").append(n).toString(), (Throwable)new Exception());
        return false;
    }

    public static interface zza {
        public boolean isConnected();

        public Bundle zzqr();
    }
}

