package bot;

import java.util.Random;

import game.Ghost;
import game.Map;
import net.NetworkManager;
import util.Position;

import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

import ai.MiniMax;

public class Bot {

	public enum Direction {
		LEFT, UP, RIGHT, DOWN
	}

	public Ghost ghost;
	
	public Map map;
	
	public MiniMax miniMax;
	
	public Bot() {
		this.map = new Map();
		this.miniMax = new MiniMax(map, 7);
	}
	
	public void update(JSONObject me) {
		if (this.ghost == null) {
			this.ghost = new Ghost(((Long) me.get("id")).intValue());
		}
		this.ghost.score = ((Long) me.get("score")).intValue();
		this.ghost.position = new Position<Integer, Integer>(
				((Long) me.get("x")).intValue(), ((Long) me.get("y")).intValue());
		this.ghost.id = ((Long) me.get("id")).intValue();
		this.ghost.isDangerous = (boolean) me.get("isdangerous");
		
		this.miniMax.calculateTree(this);
		
		Direction direction = miniMax.getBestDirection();
		move(direction);
		map.canMove = false;
	}
	
	private void move(Direction direction) {
		if (direction == null) {
			return;
		}
		NetworkManager.getInstance().send(direction.toString());
	}
}
