/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.util.Arrays;

public class GaussianBlur {
    public static float[][] blur(float[][] input, float r) {
        float[] bxs = GaussianBlur.boxesForGauss(r, 5);
        System.out.println(Arrays.toString(bxs));
        float[][] output = GaussianBlur.boxBlur(input, (bxs[0] - 1.0f) / 2.0f);
        output = GaussianBlur.boxBlur(output, (bxs[1] - 1.0f) / 2.0f);
        output = GaussianBlur.boxBlur(output, (bxs[2] - 1.0f) / 2.0f);
        return output;
    }

    private static float[][] boxBlur(float[][] input, float r) {
        float[][] output = new float[input.length][input[0].length];
        output = GaussianBlur.boxBlurH(input, r);
        output = GaussianBlur.boxBlurT(output, r);
        return output;
    }

    private static float[][] boxBlurH(float[][] input, float r) {
        float[][] output = new float[input.length][input[0].length];
        int w = input.length;
        int h = input[0].length;
        int i = 0;
        while (i < h) {
            int j = 0;
            while (j < w) {
                int val = 0;
                float ix = (float)j - r;
                while (ix < (float)j + r + 1.0f) {
                    int x = (int)Math.min((float)(w - 1), Math.max(0.0f, ix));
                    val = (int)((float)val + input[x][i]);
                    ix += 1.0f;
                }
                output[j][i] = (float)val / (r + r + 1.0f);
                ++j;
            }
            ++i;
        }
        return output;
    }

    private static float[][] boxBlurT(float[][] input, float r) {
        float[][] output = new float[input.length][input[0].length];
        int w = input.length;
        int h = input[0].length;
        int i = 0;
        while (i < h) {
            int j = 0;
            while (j < w) {
                int val = 0;
                float iy = (float)i - r;
                while (iy < (float)i + r + 1.0f) {
                    int y = (int)Math.min((float)(h - 1), Math.max(0.0f, iy));
                    val = (int)((float)val + input[j][y]);
                    iy += 1.0f;
                }
                output[j][i] = (float)val / (r + r + 1.0f);
                ++j;
            }
            ++i;
        }
        return output;
    }

    private static float[] boxesForGauss(float sigma, int n) {
        float wIdeal = (float)Math.sqrt(12.0f * sigma * sigma / (float)n + 1.0f);
        float wl = (float)Math.floor(wIdeal);
        if (wl % 2.0f == 0.0f) {
            wl -= 1.0f;
        }
        float wu = wl + 2.0f;
        float mIdeal = (12.0f * sigma * sigma - (float)n * wl * wl - (float)(4 * n) * wl - (float)(3 * n)) / (-4.0f * wl - 4.0f);
        float m = Math.round(mIdeal);
        float[] sizes = new float[n];
        int i = 0;
        while (i < n) {
            sizes[i] = (float)i < m ? wl : wu;
            ++i;
        }
        return sizes;
    }
}

