/*
 * Decompiled with CFR 0.152.
 */
package game;

import bot.Bot;
import bot.BotManager;
import game.Ghost;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import util.Position;
import util.Util;

public class Map {
    public ObstacleType[][] obstacles;
    public HashMap<Integer, Ghost> opponents;
    public boolean canMove = false;

    public Map() {
        this.opponents = new HashMap();
    }

    public Map(Map map) {
        this.obstacles = Util.deepCopy(map.obstacles);
        this.opponents = (HashMap)map.opponents.clone();
    }

    public void update(JSONObject map) {
        JSONArray array = (JSONArray)map.get("content");
        int height = ((Long)map.get("height")).intValue();
        int pelletsleft = ((Long)map.get("pelletsleft")).intValue();
        int width = ((Long)map.get("width")).intValue();
        ObstacleType[][] obstacles = new ObstacleType[width][height];
        int h = 0;
        while (h < height) {
            String row = (String)array.get(h);
            int w = 0;
            while (w < width) {
                obstacles[w][h] = this.getObstacleType(row.charAt(w));
                ++w;
            }
            ++h;
        }
        this.obstacles = obstacles;
        this.canMove = true;
    }

    public void updateOpponents(JSONArray opponents) {
        if (opponents == null) {
            return;
        }
        this.clearGhostsFromMap();
        int i = 0;
        while (i < opponents.size()) {
            JSONObject opponent = (JSONObject)opponents.get(i);
            Ghost ghost = new Ghost(((Long)opponent.get("id")).intValue());
            ghost.score = ((Long)opponent.get("score")).intValue();
            ghost.position = new Position<Integer, Integer>(((Long)opponent.get("x")).intValue(), ((Long)opponent.get("y")).intValue());
            ghost.id = ((Long)opponent.get("id")).intValue();
            ghost.isDangerous = (Boolean)opponent.get("isdangerous");
            this.obstacles[((Integer)ghost.position.x).intValue()][((Integer)ghost.position.y).intValue()] = ObstacleType.GHOST;
            if (this.opponents.containsKey(ghost.id)) {
                this.opponents.replace(ghost.id, ghost);
            } else {
                this.opponents.put(ghost.id, ghost);
            }
            ++i;
        }
    }

    private void clearGhostsFromMap() {
        int x = 0;
        while (x < this.obstacles.length) {
            int y = 0;
            while (y < this.obstacles[x].length) {
                if (this.obstacles[x][y] == ObstacleType.GHOST) {
                    this.obstacles[x][y] = ObstacleType.FLOOR;
                }
                ++y;
            }
            ++x;
        }
    }

    public List<Bot.Direction> getAvailableMoves(Position<Integer, Integer> position) {
        ArrayList<Bot.Direction> directions = new ArrayList<Bot.Direction>();
        try {
            if (this.obstacles[(Integer)position.x][(Integer)position.y - 1] != ObstacleType.WALL) {
                directions.add(Bot.Direction.UP);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.obstacles[(Integer)position.x][(Integer)position.y + 1] != ObstacleType.WALL) {
                directions.add(Bot.Direction.DOWN);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.obstacles[(Integer)position.x - 1][(Integer)position.y] != ObstacleType.WALL) {
                directions.add(Bot.Direction.LEFT);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.obstacles[(Integer)position.x + 1][(Integer)position.y] != ObstacleType.WALL) {
                directions.add(Bot.Direction.RIGHT);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return directions;
    }

    public static Position<Integer, Integer> getPosition(Position<Integer, Integer> position, Bot.Direction direction) {
        if (direction == Bot.Direction.DOWN) {
            return new Position<Integer, Integer>((Integer)position.x, (Integer)position.y + 1);
        }
        if (direction == Bot.Direction.UP) {
            return new Position<Integer, Integer>((Integer)position.x, (Integer)position.y - 1);
        }
        if (direction == Bot.Direction.LEFT) {
            return new Position<Integer, Integer>((Integer)position.x - 1, (Integer)position.y);
        }
        if (direction == Bot.Direction.RIGHT) {
            return new Position<Integer, Integer>((Integer)position.x + 1, (Integer)position.y);
        }
        return null;
    }

    private ObstacleType getObstacleType(char c) {
        switch (c) {
            case '|': {
                return ObstacleType.WALL;
            }
            case '_': {
                return ObstacleType.FLOOR;
            }
            case '.': {
                return ObstacleType.PELLET;
            }
            case 'o': {
                return ObstacleType.SUPERPELLET;
            }
            case '-': {
                return ObstacleType.DOOR;
            }
        }
        return ObstacleType.FLOOR;
    }

    public float calculateScore(Position<Integer, Integer> position) {
        int r = 3;
        float[] pascal = new float[r];
        int i = 0;
        while (i < r) {
            pascal[i] = Util.pascalTriangle(r, i + 1);
            ++i;
        }
        float score = 0.0f;
        int x = 0;
        while (x < r) {
            int y = 0;
            while (y < r) {
                score += this.getScore(new Position<Integer, Integer>((Integer)position.x - r / 2 + x, (Integer)position.y - r / 2 + y)) * pascal[x] * pascal[y];
                ++y;
            }
            ++x;
        }
        return score + this.getScore(position);
    }

    private boolean hasDeadlyGhostInRange(Position<Integer, Integer> position) {
        for (Ghost ghost : this.opponents.values()) {
            if (Math.sqrt(Math.pow((Integer)ghost.position.x - (Integer)position.x, 2.0) + Math.pow((Integer)ghost.position.y - (Integer)position.y, 2.0)) > 2.0 || !ghost.isDangerous) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private float getScore(Position<Integer, Integer> position) {
        try {
            switch (this.obstacles[(Integer)position.x][(Integer)position.y]) {
                case DOOR: {
                    return 0.0f;
                }
                case FLOOR: {
                    return 0.0f;
                }
                case GHOST: {
                    if (this.hasDeadlyGhostInRange(position)) {
                        return -25.0f;
                    }
                    if (!BotManager.getInstance().bot.ghost.isDangerous) return -0.5f;
                    return 25.0f;
                }
                case PELLET: {
                    return 1.0f;
                }
                case SUPERPELLET: {
                    return 10.0f;
                }
                case WALL: {
                    return 0.0f;
                }
            }
            return 0.0f;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0.0f;
    }

    public void clear(Position<Integer, Integer> position) {
        this.obstacles[((Integer)position.x).intValue()][((Integer)position.y).intValue()] = ObstacleType.FLOOR;
    }

    public static enum ObstacleType {
        FLOOR,
        WALL,
        DOOR,
        PELLET,
        SUPERPELLET,
        GHOST,
        PACMAN,
        ME;

    }
}

