/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.kotlin;

import com.fasterxml.jackson.databind.introspect.AnnotatedConstructor;
import com.fasterxml.jackson.databind.util.LRUMap;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import kotlin.Metadata;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import kotlin.reflect.KFunction;
import kotlin.reflect.jvm.ReflectJvmMapping;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\"\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\n2\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\u0014J\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00010\b2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00010\u0007J\u001c\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u000e2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00010\rJ\u0014\u0010\u0015\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000e2\u0006\u0010\u0012\u001a\u00020\u0010R&\u0010\u0005\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\f\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u000e0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000f\u001a\u0012\u0012\u0004\u0012\u00020\u0010\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/fasterxml/jackson/module/kotlin/ReflectionCache;", "", "reflectionCacheSize", "", "(I)V", "javaClassToKotlin", "Lcom/fasterxml/jackson/databind/util/LRUMap;", "Ljava/lang/Class;", "Lkotlin/reflect/KClass;", "javaConstructorIsCreatorAnnotated", "Lcom/fasterxml/jackson/databind/introspect/AnnotatedConstructor;", "", "javaConstructorToKotlin", "Ljava/lang/reflect/Constructor;", "Lkotlin/reflect/KFunction;", "javaMethodToKotlin", "Ljava/lang/reflect/Method;", "checkConstructorIsCreatorAnnotated", "key", "calc", "Lkotlin/Function1;", "kotlinFromJava", "jackson-module-kotlin"})
public final class ReflectionCache {
    private final LRUMap<Class<Object>, KClass<Object>> javaClassToKotlin;
    private final LRUMap<Constructor<Object>, KFunction<Object>> javaConstructorToKotlin;
    private final LRUMap<Method, KFunction<?>> javaMethodToKotlin;
    private final LRUMap<AnnotatedConstructor, Boolean> javaConstructorIsCreatorAnnotated;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final KClass<Object> kotlinFromJava(@NotNull Class<Object> key) {
        Intrinsics.checkParameterIsNotNull(key, "key");
        KClass<Object> kClass = this.javaClassToKotlin.get(key);
        if (kClass == null) {
            KClass<Object> kClass2 = JvmClassMappingKt.getKotlinClass(key);
            KClass<Object> it = kClass2;
            KClass<Object> kClass3 = this.javaClassToKotlin.putIfAbsent(key, it);
            if (kClass3 == null) {
                void var3_3;
                kClass3 = var3_3;
            }
            kClass = kClass3;
        }
        return kClass;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final KFunction<Object> kotlinFromJava(@NotNull Constructor<Object> key) {
        Intrinsics.checkParameterIsNotNull(key, "key");
        KFunction<Object> kFunction = this.javaConstructorToKotlin.get(key);
        if (kFunction == null) {
            KFunction<Object> kFunction2 = ReflectJvmMapping.getKotlinFunction(key);
            if (kFunction2 != null) {
                KFunction<Object> kFunction3 = kFunction2;
                KFunction<Object> it = kFunction3;
                KFunction<Object> kFunction4 = this.javaConstructorToKotlin.putIfAbsent(key, it);
                if (kFunction4 == null) {
                    void var3_3;
                    kFunction4 = var3_3;
                }
                kFunction = kFunction4;
            } else {
                kFunction = null;
            }
        }
        return kFunction;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final KFunction<?> kotlinFromJava(@NotNull Method key) {
        Intrinsics.checkParameterIsNotNull(key, "key");
        KFunction<?> kFunction = this.javaMethodToKotlin.get(key);
        if (kFunction == null) {
            KFunction<?> kFunction2 = ReflectJvmMapping.getKotlinFunction(key);
            if (kFunction2 != null) {
                KFunction<?> kFunction3 = kFunction2;
                KFunction<?> it = kFunction3;
                KFunction<?> kFunction4 = this.javaMethodToKotlin.putIfAbsent(key, it);
                if (kFunction4 == null) {
                    void var3_3;
                    kFunction4 = var3_3;
                }
                kFunction = kFunction4;
            } else {
                kFunction = null;
            }
        }
        return kFunction;
    }

    public final boolean checkConstructorIsCreatorAnnotated(@NotNull AnnotatedConstructor key, @NotNull Function1<? super AnnotatedConstructor, Boolean> calc) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull(key, "key");
        Intrinsics.checkParameterIsNotNull(calc, "calc");
        Boolean bl2 = this.javaConstructorIsCreatorAnnotated.get(key);
        if (bl2 != null) {
            bl = bl2;
        } else {
            Boolean bl3 = calc.invoke(key);
            boolean it = bl3;
            Boolean bl4 = this.javaConstructorIsCreatorAnnotated.putIfAbsent(key, it);
            bl = bl4 != null ? bl4 : it;
        }
        return bl;
    }

    public ReflectionCache(int reflectionCacheSize) {
        this.javaClassToKotlin = new LRUMap(reflectionCacheSize, reflectionCacheSize);
        this.javaConstructorToKotlin = new LRUMap(reflectionCacheSize, reflectionCacheSize);
        this.javaMethodToKotlin = new LRUMap(reflectionCacheSize, reflectionCacheSize);
        this.javaConstructorIsCreatorAnnotated = new LRUMap(reflectionCacheSize, reflectionCacheSize);
    }
}

