/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.util;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.annotation.NoClass;
import java.io.Closeable;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;

public final class ClassUtil {
    private static final Class<?> CLS_OBJECT = Object.class;
    private static final Annotation[] NO_ANNOTATIONS = new Annotation[0];
    private static final Ctor[] NO_CTORS = new Ctor[0];
    private static final EmptyIterator<?> EMPTY_ITERATOR = new EmptyIterator();

    public static <T> Iterator<T> emptyIterator() {
        return EMPTY_ITERATOR;
    }

    public static List<JavaType> findSuperTypes(JavaType type2, Class<?> endBefore, boolean addClassItself) {
        if (type2 == null || type2.hasRawClass(endBefore) || type2.hasRawClass(Object.class)) {
            return Collections.emptyList();
        }
        ArrayList<JavaType> result2 = new ArrayList<JavaType>(8);
        ClassUtil._addSuperTypes(type2, endBefore, result2, addClassItself);
        return result2;
    }

    public static List<Class<?>> findRawSuperTypes(Class<?> cls, Class<?> endBefore, boolean addClassItself) {
        if (cls == null || cls == endBefore || cls == Object.class) {
            return Collections.emptyList();
        }
        ArrayList result2 = new ArrayList(8);
        ClassUtil._addRawSuperTypes(cls, endBefore, result2, addClassItself);
        return result2;
    }

    public static List<Class<?>> findSuperClasses(Class<?> cls, Class<?> endBefore, boolean addClassItself) {
        LinkedList result2 = new LinkedList();
        if (cls != null && cls != endBefore) {
            if (addClassItself) {
                result2.add(cls);
            }
            while ((cls = cls.getSuperclass()) != null && cls != endBefore) {
                result2.add(cls);
            }
        }
        return result2;
    }

    @Deprecated
    public static List<Class<?>> findSuperTypes(Class<?> cls, Class<?> endBefore) {
        return ClassUtil.findSuperTypes(cls, endBefore, new ArrayList(8));
    }

    @Deprecated
    public static List<Class<?>> findSuperTypes(Class<?> cls, Class<?> endBefore, List<Class<?>> result2) {
        ClassUtil._addRawSuperTypes(cls, endBefore, result2, false);
        return result2;
    }

    private static void _addSuperTypes(JavaType type2, Class<?> endBefore, Collection<JavaType> result2, boolean addClassItself) {
        if (type2 == null) {
            return;
        }
        Class<?> cls = type2.getRawClass();
        if (cls == endBefore || cls == Object.class) {
            return;
        }
        if (addClassItself) {
            if (result2.contains(type2)) {
                return;
            }
            result2.add(type2);
        }
        for (JavaType intCls : type2.getInterfaces()) {
            ClassUtil._addSuperTypes(intCls, endBefore, result2, true);
        }
        ClassUtil._addSuperTypes(type2.getSuperClass(), endBefore, result2, true);
    }

    private static void _addRawSuperTypes(Class<?> cls, Class<?> endBefore, Collection<Class<?>> result2, boolean addClassItself) {
        if (cls == endBefore || cls == null || cls == Object.class) {
            return;
        }
        if (addClassItself) {
            if (result2.contains(cls)) {
                return;
            }
            result2.add(cls);
        }
        for (Class<?> intCls : ClassUtil._interfaces(cls)) {
            ClassUtil._addRawSuperTypes(intCls, endBefore, result2, true);
        }
        ClassUtil._addRawSuperTypes(cls.getSuperclass(), endBefore, result2, true);
    }

    public static String canBeABeanType(Class<?> type2) {
        if (type2.isAnnotation()) {
            return "annotation";
        }
        if (type2.isArray()) {
            return "array";
        }
        if (type2.isEnum()) {
            return "enum";
        }
        if (type2.isPrimitive()) {
            return "primitive";
        }
        return null;
    }

    public static String isLocalType(Class<?> type2, boolean allowNonStatic) {
        try {
            if (ClassUtil.hasEnclosingMethod(type2)) {
                return "local/anonymous";
            }
            if (!allowNonStatic && !Modifier.isStatic(type2.getModifiers()) && ClassUtil.getEnclosingClass(type2) != null) {
                return "non-static member class";
            }
        }
        catch (SecurityException e) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return null;
    }

    public static Class<?> getOuterClass(Class<?> type2) {
        try {
            if (ClassUtil.hasEnclosingMethod(type2)) {
                return null;
            }
            if (!Modifier.isStatic(type2.getModifiers())) {
                return ClassUtil.getEnclosingClass(type2);
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return null;
    }

    public static boolean isProxyType(Class<?> type2) {
        String name2 = type2.getName();
        return name2.startsWith("net.sf.cglib.proxy.") || name2.startsWith("org.hibernate.proxy.");
    }

    public static boolean isConcrete(Class<?> type2) {
        int mod = type2.getModifiers();
        return (mod & 0x600) == 0;
    }

    public static boolean isConcrete(Member member) {
        int mod = member.getModifiers();
        return (mod & 0x600) == 0;
    }

    public static boolean isCollectionMapOrArray(Class<?> type2) {
        if (type2.isArray()) {
            return true;
        }
        if (Collection.class.isAssignableFrom(type2)) {
            return true;
        }
        return Map.class.isAssignableFrom(type2);
    }

    public static String getClassDescription(Object classOrInstance) {
        if (classOrInstance == null) {
            return "unknown";
        }
        Class<?> cls = classOrInstance instanceof Class ? (Class<?>)classOrInstance : classOrInstance.getClass();
        return cls.getName();
    }

    @Deprecated
    public static Class<?> findClass(String className) throws ClassNotFoundException {
        if (className.indexOf(46) < 0) {
            if ("int".equals(className)) {
                return Integer.TYPE;
            }
            if ("long".equals(className)) {
                return Long.TYPE;
            }
            if ("float".equals(className)) {
                return Float.TYPE;
            }
            if ("double".equals(className)) {
                return Double.TYPE;
            }
            if ("boolean".equals(className)) {
                return Boolean.TYPE;
            }
            if ("byte".equals(className)) {
                return Byte.TYPE;
            }
            if ("char".equals(className)) {
                return Character.TYPE;
            }
            if ("short".equals(className)) {
                return Short.TYPE;
            }
            if ("void".equals(className)) {
                return Void.TYPE;
            }
        }
        Throwable prob = null;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader != null) {
            try {
                return Class.forName(className, true, loader);
            }
            catch (Exception e) {
                prob = ClassUtil.getRootCause(e);
            }
        }
        try {
            return Class.forName(className);
        }
        catch (Exception e) {
            if (prob == null) {
                prob = ClassUtil.getRootCause(e);
            }
            if (prob instanceof RuntimeException) {
                throw (RuntimeException)prob;
            }
            throw new ClassNotFoundException(prob.getMessage(), prob);
        }
    }

    @Deprecated
    public static boolean hasGetterSignature(Method m) {
        if (Modifier.isStatic(m.getModifiers())) {
            return false;
        }
        Class<?>[] pts = m.getParameterTypes();
        if (pts != null && pts.length != 0) {
            return false;
        }
        return Void.TYPE != m.getReturnType();
    }

    public static Throwable getRootCause(Throwable t) {
        while (t.getCause() != null) {
            t = t.getCause();
        }
        return t;
    }

    public static void throwRootCause(Throwable t) throws Exception {
        if ((t = ClassUtil.getRootCause(t)) instanceof Exception) {
            throw (Exception)t;
        }
        throw (Error)t;
    }

    public static Throwable throwRootCauseIfIOE(Throwable t) throws IOException {
        if ((t = ClassUtil.getRootCause(t)) instanceof IOException) {
            throw (IOException)t;
        }
        return t;
    }

    public static void throwAsIAE(Throwable t) {
        ClassUtil.throwAsIAE(t, t.getMessage());
    }

    public static void throwAsIAE(Throwable t, String msg) {
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        throw new IllegalArgumentException(msg, t);
    }

    public static void unwrapAndThrowAsIAE(Throwable t) {
        ClassUtil.throwAsIAE(ClassUtil.getRootCause(t));
    }

    public static void unwrapAndThrowAsIAE(Throwable t, String msg) {
        ClassUtil.throwAsIAE(ClassUtil.getRootCause(t), msg);
    }

    public static void closeOnFailAndThrowAsIAE(JsonGenerator g, Exception fail) throws IOException {
        g.disable(JsonGenerator.Feature.AUTO_CLOSE_JSON_CONTENT);
        try {
            g.close();
        }
        catch (Exception e) {
            fail.addSuppressed(e);
        }
        if (fail instanceof IOException) {
            throw (IOException)fail;
        }
        if (fail instanceof RuntimeException) {
            throw (RuntimeException)fail;
        }
        throw new RuntimeException(fail);
    }

    public static void closeOnFailAndThrowAsIAE(JsonGenerator g, Closeable toClose, Exception fail) throws IOException {
        if (g != null) {
            g.disable(JsonGenerator.Feature.AUTO_CLOSE_JSON_CONTENT);
            try {
                g.close();
            }
            catch (Exception e) {
                fail.addSuppressed(e);
            }
        }
        if (toClose != null) {
            try {
                toClose.close();
            }
            catch (Exception e) {
                fail.addSuppressed(e);
            }
        }
        if (fail instanceof IOException) {
            throw (IOException)fail;
        }
        if (fail instanceof RuntimeException) {
            throw (RuntimeException)fail;
        }
        throw new RuntimeException(fail);
    }

    public static <T> T createInstance(Class<T> cls, boolean canFixAccess) throws IllegalArgumentException {
        Constructor<T> ctor = ClassUtil.findConstructor(cls, canFixAccess);
        if (ctor == null) {
            throw new IllegalArgumentException("Class " + cls.getName() + " has no default (no arg) constructor");
        }
        try {
            return ctor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            ClassUtil.unwrapAndThrowAsIAE(e, "Failed to instantiate class " + cls.getName() + ", problem: " + e.getMessage());
            return null;
        }
    }

    public static <T> Constructor<T> findConstructor(Class<T> cls, boolean canFixAccess) throws IllegalArgumentException {
        try {
            Constructor<T> ctor = cls.getDeclaredConstructor(new Class[0]);
            if (canFixAccess) {
                ClassUtil.checkAndFixAccess(ctor);
            } else if (!Modifier.isPublic(ctor.getModifiers())) {
                throw new IllegalArgumentException("Default constructor for " + cls.getName() + " is not accessible (non-public?): not allowed to try modify access via Reflection: can not instantiate type");
            }
            return ctor;
        }
        catch (NoSuchMethodException e) {
        }
        catch (Exception e) {
            ClassUtil.unwrapAndThrowAsIAE(e, "Failed to find default constructor of class " + cls.getName() + ", problem: " + e.getMessage());
        }
        return null;
    }

    public static Object defaultValue(Class<?> cls) {
        if (cls == Integer.TYPE) {
            return 0;
        }
        if (cls == Long.TYPE) {
            return 0L;
        }
        if (cls == Boolean.TYPE) {
            return Boolean.FALSE;
        }
        if (cls == Double.TYPE) {
            return 0.0;
        }
        if (cls == Float.TYPE) {
            return Float.valueOf(0.0f);
        }
        if (cls == Byte.TYPE) {
            return (byte)0;
        }
        if (cls == Short.TYPE) {
            return (short)0;
        }
        if (cls == Character.TYPE) {
            return Character.valueOf('\u0000');
        }
        throw new IllegalArgumentException("Class " + cls.getName() + " is not a primitive type");
    }

    public static Class<?> wrapperType(Class<?> primitiveType) {
        if (primitiveType == Integer.TYPE) {
            return Integer.class;
        }
        if (primitiveType == Long.TYPE) {
            return Long.class;
        }
        if (primitiveType == Boolean.TYPE) {
            return Boolean.class;
        }
        if (primitiveType == Double.TYPE) {
            return Double.class;
        }
        if (primitiveType == Float.TYPE) {
            return Float.class;
        }
        if (primitiveType == Byte.TYPE) {
            return Byte.class;
        }
        if (primitiveType == Short.TYPE) {
            return Short.class;
        }
        if (primitiveType == Character.TYPE) {
            return Character.class;
        }
        throw new IllegalArgumentException("Class " + primitiveType.getName() + " is not a primitive type");
    }

    public static Class<?> primitiveType(Class<?> type2) {
        if (type2.isPrimitive()) {
            return type2;
        }
        if (type2 == Integer.class) {
            return Integer.TYPE;
        }
        if (type2 == Long.class) {
            return Long.TYPE;
        }
        if (type2 == Boolean.class) {
            return Boolean.TYPE;
        }
        if (type2 == Double.class) {
            return Double.TYPE;
        }
        if (type2 == Float.class) {
            return Float.TYPE;
        }
        if (type2 == Byte.class) {
            return Byte.TYPE;
        }
        if (type2 == Short.class) {
            return Short.TYPE;
        }
        if (type2 == Character.class) {
            return Character.TYPE;
        }
        return null;
    }

    @Deprecated
    public static void checkAndFixAccess(Member member) {
        ClassUtil.checkAndFixAccess(member, false);
    }

    public static void checkAndFixAccess(Member member, boolean force) {
        block3: {
            AccessibleObject ao = (AccessibleObject)((Object)member);
            try {
                if (force || !Modifier.isPublic(member.getModifiers()) || !Modifier.isPublic(member.getDeclaringClass().getModifiers())) {
                    ao.setAccessible(true);
                }
            }
            catch (SecurityException se) {
                if (ao.isAccessible()) break block3;
                Class<?> declClass = member.getDeclaringClass();
                throw new IllegalArgumentException("Can not access " + member + " (from class " + declClass.getName() + "; failed to set access: " + se.getMessage());
            }
        }
    }

    public static Class<? extends Enum<?>> findEnumType(EnumSet<?> s) {
        if (!s.isEmpty()) {
            return ClassUtil.findEnumType((Enum)s.iterator().next());
        }
        return EnumTypeLocator.instance.enumTypeFor(s);
    }

    public static Class<? extends Enum<?>> findEnumType(EnumMap<?, ?> m) {
        if (!m.isEmpty()) {
            return ClassUtil.findEnumType((Enum)m.keySet().iterator().next());
        }
        return EnumTypeLocator.instance.enumTypeFor(m);
    }

    public static Class<? extends Enum<?>> findEnumType(Enum<?> en) {
        Class<?> ec = en.getClass();
        if (ec.getSuperclass() != Enum.class) {
            ec = ec.getSuperclass();
        }
        return ec;
    }

    public static Class<? extends Enum<?>> findEnumType(Class<?> cls) {
        if (cls.getSuperclass() != Enum.class) {
            cls = cls.getSuperclass();
        }
        return cls;
    }

    public static <T extends Annotation> Enum<?> findFirstAnnotatedEnumValue(Class<Enum<?>> enumClass, Class<T> annotationClass) {
        Field[] fields2;
        for (Field field : fields2 = ClassUtil.getDeclaredFields(enumClass)) {
            T defaultValueAnnotation;
            if (!field.isEnumConstant() || (defaultValueAnnotation = field.getAnnotation(annotationClass)) == null) continue;
            String name2 = field.getName();
            for (Enum<?> enumValue : enumClass.getEnumConstants()) {
                if (!name2.equals(enumValue.name())) continue;
                return enumValue;
            }
        }
        return null;
    }

    public static boolean isJacksonStdImpl(Object impl) {
        return impl != null && ClassUtil.isJacksonStdImpl(impl.getClass());
    }

    public static boolean isJacksonStdImpl(Class<?> implClass) {
        return implClass.getAnnotation(JacksonStdImpl.class) != null;
    }

    public static boolean isBogusClass(Class<?> cls) {
        return cls == Void.class || cls == Void.TYPE || cls == NoClass.class;
    }

    public static boolean isNonStaticInnerClass(Class<?> cls) {
        return !Modifier.isStatic(cls.getModifiers()) && ClassUtil.getEnclosingClass(cls) != null;
    }

    public static boolean isObjectOrPrimitive(Class<?> cls) {
        return cls == CLS_OBJECT || cls.isPrimitive();
    }

    public static String getPackageName(Class<?> cls) {
        Package pkg = cls.getPackage();
        return pkg == null ? null : pkg.getName();
    }

    public static boolean hasEnclosingMethod(Class<?> cls) {
        return !ClassUtil.isObjectOrPrimitive(cls) && cls.getEnclosingMethod() != null;
    }

    public static Field[] getDeclaredFields(Class<?> cls) {
        return cls.getDeclaredFields();
    }

    public static Method[] getDeclaredMethods(Class<?> cls) {
        return cls.getDeclaredMethods();
    }

    public static Annotation[] findClassAnnotations(Class<?> cls) {
        if (ClassUtil.isObjectOrPrimitive(cls)) {
            return NO_ANNOTATIONS;
        }
        return cls.getDeclaredAnnotations();
    }

    public static Ctor[] getConstructors(Class<?> cls) {
        if (cls.isInterface() || ClassUtil.isObjectOrPrimitive(cls)) {
            return NO_CTORS;
        }
        Constructor<?>[] rawCtors = cls.getDeclaredConstructors();
        int len = rawCtors.length;
        Ctor[] result2 = new Ctor[len];
        for (int i = 0; i < len; ++i) {
            result2[i] = new Ctor(rawCtors[i]);
        }
        return result2;
    }

    public static Class<?> getDeclaringClass(Class<?> cls) {
        return ClassUtil.isObjectOrPrimitive(cls) ? null : cls.getDeclaringClass();
    }

    public static Type getGenericSuperclass(Class<?> cls) {
        return cls.getGenericSuperclass();
    }

    public static Type[] getGenericInterfaces(Class<?> cls) {
        return cls.getGenericInterfaces();
    }

    public static Class<?> getEnclosingClass(Class<?> cls) {
        return ClassUtil.isObjectOrPrimitive(cls) ? null : cls.getEnclosingClass();
    }

    private static Class<?>[] _interfaces(Class<?> cls) {
        return cls.getInterfaces();
    }

    public static final class Ctor {
        public final Constructor<?> _ctor;
        private Annotation[] _annotations;
        private Annotation[][] _paramAnnotations;
        private int _paramCount = -1;

        public Ctor(Constructor<?> ctor) {
            this._ctor = ctor;
        }

        public Constructor<?> getConstructor() {
            return this._ctor;
        }

        public int getParamCount() {
            int c = this._paramCount;
            if (c < 0) {
                this._paramCount = c = this._ctor.getParameterTypes().length;
            }
            return c;
        }

        public Class<?> getDeclaringClass() {
            return this._ctor.getDeclaringClass();
        }

        public Annotation[] getDeclaredAnnotations() {
            Annotation[] result2 = this._annotations;
            if (result2 == null) {
                result2 = this._ctor.getDeclaredAnnotations();
                this._annotations = result2;
            }
            return result2;
        }

        public Annotation[][] getParameterAnnotations() {
            Annotation[][] result2 = this._paramAnnotations;
            if (result2 == null) {
                result2 = this._ctor.getParameterAnnotations();
                this._paramAnnotations = result2;
            }
            return result2;
        }
    }

    private static class EnumTypeLocator {
        static final EnumTypeLocator instance = new EnumTypeLocator();
        private final Field enumSetTypeField = EnumTypeLocator.locateField(EnumSet.class, "elementType", Class.class);
        private final Field enumMapTypeField = EnumTypeLocator.locateField(EnumMap.class, "elementType", Class.class);

        private EnumTypeLocator() {
        }

        public Class<? extends Enum<?>> enumTypeFor(EnumSet<?> set) {
            if (this.enumSetTypeField != null) {
                return (Class)this.get(set, this.enumSetTypeField);
            }
            throw new IllegalStateException("Can not figure out type for EnumSet (odd JDK platform?)");
        }

        public Class<? extends Enum<?>> enumTypeFor(EnumMap<?, ?> set) {
            if (this.enumMapTypeField != null) {
                return (Class)this.get(set, this.enumMapTypeField);
            }
            throw new IllegalStateException("Can not figure out type for EnumMap (odd JDK platform?)");
        }

        private Object get(Object bean, Field field) {
            try {
                return field.get(bean);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
        }

        private static Field locateField(Class<?> fromClass, String expectedName, Class<?> type2) {
            Field[] fields2;
            Field found = null;
            for (Field f : fields2 = ClassUtil.getDeclaredFields(fromClass)) {
                if (!expectedName.equals(f.getName()) || f.getType() != type2) continue;
                found = f;
                break;
            }
            if (found == null) {
                for (Field f : fields2) {
                    if (f.getType() != type2) continue;
                    if (found != null) {
                        return null;
                    }
                    found = f;
                }
            }
            if (found != null) {
                try {
                    found.setAccessible(true);
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
            return found;
        }
    }

    private static final class EmptyIterator<T>
    implements Iterator<T> {
        private EmptyIterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public T next() {
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

