#version 330 core
out vec4 FragColor;

in VS_OUT {
    vec3 FragPos;
    flat vec3 Normal;
    vec2 TexCoords;
	float Pulse;
} fsIn;

uniform vec3 lightPos;
uniform vec3 viewPos;
uniform vec3 pulseColor;

void main()
{
    vec3 color = vec3(0.0, 0.0, 0.0);

    vec3 ambient = 0.1 * color;

    vec3 lightDir = normalize(lightPos - fsIn.FragPos);
    vec3 normal = normalize(fsIn.Normal);
    float diff = max(dot(lightDir, normal), 0.0);
    vec3 diffuse = diff * color;

    vec3 viewDir = normalize(viewPos - fsIn.FragPos);
    
    float spec = 0.0;
    vec3 halfwayDir = normalize(lightDir + viewDir);  
    spec = pow(max(dot(normal, halfwayDir), 0.0), 128.0);
    
    vec3 specular = vec3(0.3) * spec;
    FragColor = vec4(ambient + diffuse + specular + fsIn.Pulse*pulseColor, 1.0f);

	float gamma = 2.2;
    FragColor.rgb = pow(FragColor.rgb, vec3(1.0/gamma));
}