#version 330 core
layout (location = 0) in vec3 position;
layout (location = 1) in vec3 normal;
layout (location = 2) in vec2 texCoords;

out VS_OUT {
    vec3 FragPos;
    vec3 Normal;
    vec2 TexCoords;
	vec3 ModelPos;
} vsOut;

uniform mat4 projection;
uniform mat4 view;
uniform mat4 model;

void main()
{
    gl_Position = projection * view * model * vec4(position, 1.0f);
    vsOut.FragPos = position;
    vsOut.Normal = (mat3(view * model)) * normal;
    vsOut.TexCoords = texCoords;
	vsOut.ModelPos = position;
}