#version 330 core
out vec4 FragColor;

in VS_OUT {
    vec3 FragPos;
    vec3 Normal;
    vec2 TexCoords;
} fsIn;

uniform sampler2D uiTexture;
uniform float alpha = 1.0f;
uniform float time;

void main()
{
	vec2 tc = fsIn.TexCoords;
	//tc.y *= -1.0f;
    vec4 color = texture(uiTexture, tc) * vec4(vec3(0.3),1.0);;
	color.a *= alpha;

	float l = sin(time + tc.x*10.0) * 0.5 + 0.5;
	//color.a = l * color.a;
	//vec4 color2 = mix(vec4(0,0,0,1), color, l);
	//color.a = l;
    FragColor = color;

	//float gamma = 2.2;
    //FragColor.rgb = pow(FragColor.rgb, vec3(1.0/gamma));
}