#version 330 core
layout (location = 0) in vec3 position;
layout (location = 1) in vec3 normal;

uniform mat4 projection;
uniform mat4 view;
uniform mat4 model;
uniform float time;

void main()
{
    float freqx = 1.13f+sin(time)*1.0f;
	float freqy = 1.2f+sin(time*1.3f)*1.0f;
	float freqz = 1.1f+sin(time*1.1f)*1.0f;
	float amp = 0.3f+sin(time*1.4)*1.0f;

	vec3 pos = position;
	float f = sin(normal.x*freqx + time) * sin(normal.y*freqy + time) * sin(normal.z*freqz + time);
	pos.z += normal.z * freqz * amp * f;
	pos.x += normal.x * freqx* amp * f;
	pos.y += normal.y * freqy* amp * f;

    gl_Position = projection * view * model * vec4(pos, 1.0f);
}
 