#version 330 core
layout (triangles) in;
layout (triangle_strip, max_vertices = 3) out;

out VS_OUT {
    vec3 FragPos;
    vec3 Normal;
    vec2 TexCoords;
} vsOut;

in VS_OUT {
    vec3 FragPos;
    vec3 Normal;
    vec2 TexCoords;
} gs_in[];

uniform mat4 projection;
uniform mat4 view;
uniform mat4 model;
uniform float time;

vec3 GetNormal()
{
    vec3 a = vec3(gl_in[0].gl_Position) - vec3(gl_in[1].gl_Position);
    vec3 b = vec3(gl_in[2].gl_Position) - vec3(gl_in[1].gl_Position);
    return normalize(cross(a, b));
}

void main() {
	mat4 pvm = projection * view * model;
    gl_Position = pvm * (gl_in[0].gl_Position);
    vsOut.TexCoords = gs_in[0].TexCoords;
	vsOut.Normal = mat3(view) * gs_in[0].Normal;
	vsOut.FragPos = gs_in[0].FragPos;
    EmitVertex();
	
    gl_Position = pvm * (gl_in[1].gl_Position);
    vsOut.TexCoords = gs_in[1].TexCoords;
	vsOut.Normal = mat3(view) * gs_in[1].Normal;
	vsOut.FragPos = gs_in[1].FragPos;
    EmitVertex();
	
    gl_Position = pvm * (gl_in[2].gl_Position);
    vsOut.TexCoords = gs_in[2].TexCoords;
	vsOut.Normal = mat3(view) * gs_in[2].Normal;
	vsOut.FragPos = gs_in[2].FragPos;
    EmitVertex();
    EndPrimitive();
}