#version 330 core
out vec4 FragColor;

in vec2 TexCoords;

uniform sampler2D colorImage;

int samples = 10;
float quality = 2.5;
uniform vec2 screenSize = vec2(1920, 1080);

void main()
{
	vec4 sum = vec4(0);
	vec2 texcoord = TexCoords;
	vec4 color = texture(colorImage, texcoord);
	
	int r = (samples - 1) / 2;
	vec2 sF = vec2(1) / screenSize * quality;
	for (int x = -r; x <= r; x++)
	{
		for (int y = -r; y <= r; y++)
		{
			vec2 offset = vec2(x, y) * sF;
			sum += texture(colorImage, texcoord + offset);
		}
	}
	FragColor = ((sum / (samples * samples)) + color);
	//FragColor = color;
}