#version 330 core
out vec4 FragColor;

in vec2 TexCoords;

uniform sampler2D uiTexture;
uniform float alpha = 1.0;
uniform vec3 setColor = vec3(1,1,1);
uniform float colorify = 0.0;

void main()
{
	vec2 tc = TexCoords;
	tc.y *= -1.0;
    vec4 color = texture(uiTexture, tc);
	color.a *= alpha;
	vec4 bwC = vec4(vec3(color.r+color.g+color.b)/3.0,color.a);

    FragColor = mix(bwC, color * vec4(setColor,1), colorify);

	//float gamma = 2.2;
    //FragColor.rgb = pow(FragColor.rgb, vec3(1.0/gamma));
}