#version 330 core
layout (location = 0) in vec3 position;
layout (location = 1) in vec3 normal;
layout (location = 2) in vec2 texCoords;

out VS_OUT {
    vec3 Normal;
    vec4 Position;
} vsOut;

uniform mat4 projection;
uniform mat4 view;
uniform mat4 model;

void main()
{
	vsOut.Position = view * model * vec4(position,1);
	vsOut.Normal = transpose(mat3(view * model)) * normal;
    gl_Position = projection * view * model * vec4(position, 1.0f); 
}
 