#version 330 core
out vec4 FragColor;

in VS_OUT {
    vec3 Normal;
    vec4 Position;
} fsIn;

void main()
{
	vec3 N = normalize(fsIn.Normal);
	vec3 P = fsIn.Position.xyz;
	vec3 I = normalize(P);
	float cosTheta = abs(dot(I, N));
	float fresnel = pow(1.0 - cosTheta, 2.0);
	FragColor = vec4( gl_FragCoord.z, 1-fresnel, 0, 0);
}