attribute vec4 pos;
varying vec2 tc;

void main()
{
	tc = (pos.xy+1.0)/2.0;
	gl_Position = vec4(pos.xy, 0.0, 1.0);
}

//FRAGMENT

//#version 120
//varying vec2 tc;

uniform sampler2D Texture0;
uniform vec2 texelSize; //direction is premultiplied
uniform float weights[64];
uniform int taps;
uniform float time;



float rand(vec2 co){
    return fract(sin(dot(co.xy ,vec2(12.9898,78.233))) * 43758.5453);
}


void main(void)
{
	vec4 sum = vec4(0.f);
	int j=0;

	float jitterScale = (texelSize*taps/2.0)*20.300;

	for(int i=-taps/2;i<(taps/2+1);i++) {
		vec2 add = vec2(i)*texelSize;
		float a = rand(vec2(time+tc)+vec2((tc.x*24.2+add.x)*5442.230, (tc.y*434.3+add.y)*4323.43));
		float b = rand(vec2(time-tc)+vec2((tc.y*34.0+add.y)*2434.2, (tc.x*543.3+add.x)*9434.5));
		a=a*2.0-1.0;
		b=b*2.0-1.0;
		vec2 jitter = jitterScale*texelSize*vec2(a, b);// rand(add.x, add.y), rand(add.y, add.x) );
		vec2 tcBlur = clamp(tc+add+jitter, vec2(0.0f), vec2(1.0));
		sum += texture2D(Texture0, tcBlur)*weights[j];
		j+=1;
	}

	gl_FragColor = sum;//clamp(sum, vec4(0.0), vec4(1.0));
	//gl_FragColor = texture2D(Texture0, tc);
}
