#version 330 core

in vec2 texCoord;
in vec4 vertexFragColor;
out vec4 fragColor;
uniform sampler2D texture0;
uniform vec4 color = vec4(1,1,1,1);
uniform float time = 1.0;
uniform float perspective = 1.67;
uniform float scale = 1.0;
uniform vec2 position = vec2(0.5,0.5);

float rand(vec2 coord)
{
    return fract(sin(dot(coord.st,vec2(12.9898,78.233)+time)) * 43758.5453);
}

void main()
{
    vec2 coord=texCoord;
    coord -= vec2(position.x,position.y);
    coord.x *= perspective;

    float d = sqrt(dot(coord, coord));
    float skewMax = 0.2;
    float skew = rand(vec2(coord.t))*skewMax;
    float radiusMin = 0.1+skew;
    float radiusMax = 0.15+skew;

    if (d < radiusMin || d > radiusMax) {
        fragColor = vec4(0,0,0,0);//texture(texture0, texCoord) * color;
    } else {
        fragColor = vec4(vec3(1*(skew/skewMax)),1) * color;
    }
}
