#ifdef GL_ES
precision mediump float;
precision mediump int;
#endif

uniform sampler2D texture;
uniform vec2 texOffset;
uniform int power;

varying vec4 vertColor;
varying vec4 vertTexCoord;

void main() {
	vec2 offsetCoord = vec2(1*texOffset.s,vertTexCoord.t);
	vec4 colOffset = texture2D(texture, offsetCoord);
	float offsetX = vertTexCoord.s+colOffset.r*power*255*texOffset.s/100;	
	if (offsetX>1.0) offsetX=1.0;
	offsetCoord = vec2(offsetX, vertTexCoord.t);
	vec4 col0 = texture2D(texture, offsetCoord);
	gl_FragColor = col0 * vertColor;
}