#ifdef GL_ES
precision mediump float;
precision mediump int;
#endif

uniform sampler2D texture;
uniform vec2 texOffset;
uniform int power;

varying vec4 vertColor;
varying vec4 vertTexCoord;

void main() {
	vec2 offsetCoordR = vertTexCoord.st+vec2(-power*texOffset.s,-power*texOffset.t);
	vec2 offsetCoordG = vertTexCoord.st+vec2(power*texOffset.s/2.0f,-power*texOffset.t/3.0f);
	vec2 offsetCoordB = vertTexCoord.st+vec2(-power*texOffset.s/5.0f,power*texOffset.t);
	float red = texture2D(texture, offsetCoordR).r;
	float green = texture2D(texture, offsetCoordG).g;
	float blue = texture2D(texture, offsetCoordB).b;
	gl_FragColor = vec4(red, green, blue, 255.0f) * vertColor;
}