#ifdef GL_ES
precision mediump float;
precision mediump int;
#endif

uniform sampler2D texture;
uniform vec2 texOffset;
uniform int power;

varying vec4 vertColor;
varying vec4 vertTexCoord;

void main() {
	highp int vertTexCoordX = int(vertTexCoord.s/texOffset.s);
	highp int vertTexCoordY = int(vertTexCoord.t/texOffset.t); 
	vertTexCoordX/=power;
	vertTexCoordY/=power;
	vertTexCoordX*=power;
	vertTexCoordY*=power;
	vec2 tc0 = vec2(vertTexCoordX*texOffset.s, vertTexCoordY*texOffset.t);
	vec4 col0 = texture2D(texture, tc0);
	gl_FragColor = col0 * vertColor;
}
