//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using

namespace Framefield.Core.ID7cb9791a_cc3f_45a5_9c04_602b4a40f6a4
{
    public class Class_DirectionalBlur : FXImageFunction
    {
        //>>> _inputids
        private enum InputId
        {
            Code = 0,
            Image = 1,
            Glow = 2,
            Offset = 3,
            Angle = 4,
            SampleCount = 5,
            Strength = 6
        }
        //<<< _inputids
        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx)
        {
            //>>> _params
            var Code = inputs[(int)InputId.Code].Eval(context).Text;
            var Image = inputs[(int)InputId.Image].Eval(context).Image; if (Image == null) return context;
            var Glow = inputs[(int)InputId.Glow].Eval(context).Value;
            var Offset = inputs[(int)InputId.Offset].Eval(context).Value;
            var Angle = inputs[(int)InputId.Angle].Eval(context).Value;
            var SampleCount = inputs[(int)InputId.SampleCount].Eval(context).Value;
            var Strength = inputs[(int)InputId.Strength].Eval(context).Value;
            //<<< _params

            return PrepareAndEvalOnChange(context, () => {
                ClearRenderTarget(context, new SharpDX.Color4(0, 0, 0, 1));

                //>>> _setup
                using (var ImageView = new ShaderResourceView(context.D3DDevice, Image))
                {
                    _effect.GetVariableByName("RenderTargetSize").AsVector().Set(new Vector2(_usedViewport.Width, _usedViewport.Height));
                    _effect.GetVariableByName("Image").AsShaderResource().SetResource(ImageView);
                    _effect.GetVariableByName("Glow").AsScalar().Set(Glow);
                    _effect.GetVariableByName("Offset").AsScalar().Set(Offset);
                    _effect.GetVariableByName("Angle").AsScalar().Set(Angle);
                    _effect.GetVariableByName("SampleCount").AsScalar().Set(SampleCount);
                    _effect.GetVariableByName("Strength").AsScalar().Set(Strength);
                //<<< _setup

                Render(context);

                //>>> _cleanup
                }
                //<<< _cleanup
            });
        }

    }
}

