#version 120

#define M_PI 3.1415926535897932384626433832795

uniform float time = 1.0f;
uniform vec2 scale = vec2(10,10);
uniform int gradient = 0;

vec4 plasma()
{
    vec2 coord = gl_TexCoord[0].st * scale;
    float d = 0.0;
    d+=sin(coord.x+time)*1.1;
    d+=cos(coord.y+time)*1.1;
    d-=sin(coord.x+coord.y+time);
    coord += vec2(sin(coord.x+time*4), cos(coord.y+time*8))*0.04;
    d += sin(sqrt(d*10+coord.x*coord.x+coord.y*coord.y)+time);
    d += cos(M_PI*1.4*time*0.3+d);

    d = 0.97+(2-d)*0.03;
    if (d>1) {d=1;}

    vec4 color = vec4(vec3(d), 1);

    if (gradient == 1) {
        //blue: 4b95c1
        vec4 blue = vec4(1,1,1,gl_Color.a);
        vec4 orange = vec4(1,1,1,gl_Color.a);

        float p = 0;
        if (gl_TexCoord[0].t > 0.6) {
            p = (gl_TexCoord[0].t-0.6)/0.4;
        }

        color = mix(blue, orange, p);
    }

    return color;
}

void main()
{
    gl_FragColor = plasma() * gl_Color;
}
