var TICK;

var fontName = "coolvetica rg.ttf";
var fontPrimaryColor = {"r":0x5f,"g":0xcb,"b":0xef};
var fontSecondaryColor = {"r":0x7f,"g":0x7f,"b":0x7f};

Demo.prototype.preInitEndAnimation = function(layer, start, duration) {
	var textDuration = duration-4
	var textDurationFade = 1;

	this.loader.addAnimation([
	{
		 "start": start, "duration": textDuration
		,"image": "data/white.png"
		,"color": [
			 {"a":0}
			,{"a":255, "duration":textDurationFade}
		]
		,"layer": layer
	}]);

	this.loader.addAnimation([
	{
		 "start": start, "duration": textDuration
		,"image": "data/jml_end_title.png"
		,"color": [
			 {"a":0}
			,{"a":255, "duration":textDurationFade}
			,{"duration":textDuration-textDurationFade*2}
			,{"a":0, "duration":textDurationFade}
		]
		,"layer": layer
	}]);
}

Demo.prototype.preInitTotalProfit = function(start, layer) {
	var TEXT_DURATION = 0.3;
	var texts = [
		 {"name":"DO","start":0.8,"duration":TEXT_DURATION}
		,{"name":"YOU","start":1.1,"duration":TEXT_DURATION}
		,{"name":"WANT","start":1.5,"duration":TEXT_DURATION}
		,{"name":"TOTAL","start":3.3,"duration":TEXT_DURATION}
		,{"name":"PROFIT?","start":3.7,"duration":TEXT_DURATION}
		,{"name":"YES","start":5.5,"duration":TEXT_DURATION}
		,{"name":"YOU","start":5.9,"duration":TEXT_DURATION}
		,{"name":"WANT","start":6.2,"duration":TEXT_DURATION}
		,{"name":"TOTAL","start":8.0,"duration":TEXT_DURATION}
		,{"name":"PROFIT.","start":8.5,"duration":TEXT_DURATION}
	];

	for(var i = 0; i < texts.length; i++)
	{
		var transmission = texts[i];
		var fade = 0.1;
		this.loader.addAnimation([
		{
			 "start":start+transmission.start-1, "duration": transmission.duration
			,"layer": layer, "text":{"name":fontName,"string":transmission.name}
			,"scale": [{"uniform2d":4}]
			,"color":[{"r":0,"g":0,"b":0,"a":0},{"duration":fade,"a":255},{"duration":transmission.duration-fade*2},{"duration":fade,"a":0}]
		}]);
	}
}

Demo.prototype.preInitPowerPoint = function(start, duration) {
	var layer = 500;
	var loadingTime = 2;

	//PPT loader
	this.loader.addAnimation([
	{
		 "start":start, "duration": loadingTime
		,"layer": layer
		,"image": "data/ppt_empty.png"
		,"color": [{"a":255}]
		
	}]);
	var pptLoadingDuration = 1.5;
	this.loader.addAnimation([
	{
		 "start":start, "duration": loadingTime
		,"layer": layer
		,"image": "data/ppt_office.png"
		,"position": [{"x":405,"y":483},{"duration":pptLoadingDuration,"x":425}]
		,"color": [{"a":0},{"duration":pptLoadingDuration,"a":255}]
	}]);

	this.loader.addAnimation([
	{
		 "start":start, "duration": loadingTime
		,"layer": layer
		,"image": "data/ppt_powerpoint.png"
		,"position": [{"x":615,"y":370},{"duration":pptLoadingDuration,"x":635}]
		,"color": [{"a":0},{"duration":pptLoadingDuration,"a":255}]
		//,"color": [{"b":0,"r":0,"a":255}]		
	}]);

	start += loadingTime;
	duration -= loadingTime;

	var firstSlideDuration = 4.0;
	this.loader.addAnimation([
	{
		 "start":start, "duration": duration
		,"layer": layer
		,"image": "data/ppt_slide.png"
		,"color": [{"a":255}]
	}]);

	this.loader.addAnimation([
	{
		 "start":start, "duration": firstSlideDuration
		,"layer": layer, "text":{"name":fontName,"string":"JML Coin"}
		,"color": [
			   fontPrimaryColor
			  ,{"duration":firstSlideDuration-0.5}
			  ,{"duration":0.5,"a":0}
		]
		,"scale": [{"uniform2d":1.3}]
		,"position": [{"x":485,"y":340}]
	}]);

	this.loader.addAnimation([
	{
		 "start":start, "duration": firstSlideDuration
		,"layer": layer, "text":{"name":fontName,"string":"Jumalauta"}
		,"color": [
			   {"r":fontSecondaryColor.r,"g":fontSecondaryColor.g,"b":fontSecondaryColor.b}
			  ,{"duration":firstSlideDuration-0.5}
			  ,{"duration":0.5,"a":0}
		]
		,"scale": [{"uniform2d":0.8}]
		,"position": [{"x":445,"y":260}]
	}]);

    this.loader.addAnimation([
    {
         "start": start, "duration": duration, "layer": layer
        ,"object": "data/dollar.obj"
        ,"angle":[{"degreesX":-90},{"duration":duration,"degreesZ":-360*20}]
        ,"color":[{"a":0},{"duration":firstSlideDuration},{"duration":1,"a":255}]
    }]);

    for(var i = 0; i < 100; i++) {
    	var fadeDelay = 0.5;
		this.loader.addAnimation([
		{
			 "start":10+start+i*fadeDelay, "duration": duration*2
			,"layer": layer
			,"image": "data/money/bill0"+(Math.floor(Math.random()*7+1))+".png"
			,"color": [{"a":0},{"duration":fadeDelay,"a":255}]
			,"position":[{"x":getScreenWidth()*Math.random(),"y":getScreenHeight()*Math.random()}]
			,"scale":[{"uniform2d":0.3+Math.random()*0.2}]
			,"angle":[{"degreesZ":Math.random()*360}]
		}]);
    }

    for(var i = 0; i < 4; i++) {
	    this.preInitTotalProfit(start+8+i*10,layer);
    }
}

Demo.prototype.init = function() {
	this.preInitPowerPoint(0, 50);
	this.preInitEndAnimation(600, 50, 30);
}

