// This is not a representation of how things should be done.

const SCREENX = window.innerWidth;
const SCREENY = window.innerHeight;
const SCALE = 50;
const TIME0 = Date.now();

var mat4 = {
	// defining dimension 4 matrices
	identity: function() {
		return [
			1, 0, 0, 0,
			0, 1, 0, 0,
			0, 0, 1, 0,
			0, 0, 0, 1,
		];
	},
	rotationZ: function(rad){
		var c = Math.cos(rad);
		var s = Math.sin(rad);
		return [
			c, s, 0, 0,
			-s, c, 0, 0,
			0, 0, 1, 0,
			0, 0, 0, 1,
		];
	},
	rotationX: function(rad){
		var c = Math.cos(rad);
		var s = Math.sin(rad);
		return [
			1, 0, 0, 0,
			0, c, -s, 0,
			0, s, c, 0,
			0, 0, 0, 1,
		];
	},
	rotationY: function(rad){
		var c = Math.cos(rad);
		var s = Math.sin(rad);
		return [
			c, 0, s, 0,
			0, 1, 0, 0,
			-s, 0, c, 0,
			0, 0, 0, 1,
		];
	},
	translation: function(tx, ty, tz){
		return [
			1, 0, 0, 0,
			0, 1, 0, 0,
			0, 0, 1, 0,
			tx, ty, tz, 1,
		];
	},
	scale: function(sx, sy, sz){
		return [
			sx, 0, 0, 0,
			0, sy, 0, 0,
			0, 0, sz, 0,
			0, 0, 0, 1,
		];
	},
};

function matMultiply4(m1, m2) {
	// 4x4 matrix multiply
	var matrix = [];

	for (i=0; i<4; i++){
		for (j=0; j<4; j++){
			ii = 4*i;
			matrix.push(
				m1[j]*m2[ii]+m1[j+4]*m2[ii+1]+m1[j+8]*m2[ii+2]+m1[j+12]*m2[ii+3]
			);
		}
	}
	return matrix;
}

function matVecMultiply4(m, vec) {
	// 4x4 matrix and 4x1 vector multiply
	var resvec = [];

	for (i=0; i<4; i++){
		resvec.push(
			m[i+0]*vec[0]+m[i+4]*vec[1]+m[i+8]*vec[2]+m[i+12]*vec[3]
		);
	}
	return resvec;
}

function spawnNode(classname, sourcename, initX, initY, initZ, center, angleY){
	// Spawns an image to be controlled with it's classmates
	var moi = document.createElement("IMG");
	moi.id = "moiman"
	moi.setAttribute("class", classname);
	moi.src = sourcename;
	moi.style.position = "absolute";
	moi.style.width = ""+(SCALE-initZ)+"px";
	moi.style.height = "auto";
	moi.style.zindex = "initZ";
	moi.setAttribute("x", initX);
	moi.setAttribute("y", initY);
	moi.setAttribute("z", initZ);
	moi.setAttribute("centerX", center[0]);
	moi.setAttribute("centerY", center[1]);
	document.body.appendChild(moi);
	moi.style.left = ""+(center[0]+Number(moi.getAttribute("x"))-(moi.offsetWidth/2))+"px";
	moi.style.top = ""+(center[1]+Number(moi.getAttribute("y"))-(moi.offsetHeight/2))+"px";

	indRotate(moi,angleY);
	moi.setAttribute("initAngleY", angleY);

}

function makeCircle(id, file){
	// Let's make shapes, yay
	var amount1 = 10; // how many?
	var amount2 = 8;
	var c = [SCREENX/2, SCREENY/2];
	var r = 200;
	for (var i = 0; i < amount2; ++i){
		var angleY = Math.PI/amount2*(i+1);
		for (var j = 0; j < amount1; ++j){
			spawnNode(id, file, r*Math.cos(2*Math.PI/amount1*(j+1)), r*Math.sin(2*Math.PI/amount1*(j+1)), 0, c, angleY);
		}
	}
}

function rotate(classname, radY, radX){
	var elems = document.getElementsByClassName(classname);
	for (var i = 0; i < elems.length; ++i){
		var initAngleY = Number(elems[i].getAttribute("initAngleY"));
		var rotMatrixY = mat4.rotationY(radY+initAngleY);
		var rotMatrixX = mat4.rotationX(radX);
		var rotMatrix = matMultiply4(rotMatrixX, rotMatrixY);
		coords = [Number(elems[i].getAttribute("x")),
				  Number(elems[i].getAttribute("y")),
				  Number(elems[i].getAttribute("z")), 0];
		
				  coords = matVecMultiply4(rotMatrix, coords);
		indPlacement(elems[i], coords, radY+initAngleY, radX);
	}
}

function indRotate(elem, rad){
	rotMatrix = mat4.rotationY(rad)
	coords = [Number(elem.getAttribute("x")),
			  Number(elem.getAttribute("y")),
			  Number(elem.getAttribute("z")), 0];
	coords = matVecMultiply4(rotMatrix, coords);
	indPlacement(elem, coords, rad);
}

function indPlacement(elem, coords, radY, radX){
	// places elem

	var center = [Number(elem.getAttribute("centerX")),
				  Number(elem.getAttribute("centerY"))];
	elem.style.left = ""+(center[0]+coords[0]-(elem.offsetWidth/2))+"px";
	elem.style.top = ""+(center[1]+coords[1]-(elem.offsetHeight/2))+"px";
	elem.style.width = ""+(SCALE*(500+coords[2])/500)+"px";
	elem.style.height = "auto";
	elem.style.zIndex = Math.round(coords[2])+"";
	
}

function transform_circle(classname, thing, value){

	if (thing=="r"){
		var c = [SCREENX/2, SCREENY/2];
		var r = 100+value;
		var elems = document.getElementsByClassName(classname);
		for (var i = 0; i < elems.length; ++i){

			var x = Number(elems[i].getAttribute("x"));
			var y = Number(elems[i].getAttribute("y"));
			var z = Number(elems[i].getAttribute("z"));
			var len = Math.sqrt(Math.pow(x,2)+Math.pow(y,2)+Math.pow(z,2));
			elems[i].setAttribute("x",x/len*r);
			elems[i].setAttribute("y",y/len*r);
			elems[i].setAttribute("z",z/len*r);
			
			//spädere
			elems[i].src=("v"+Math.round(Math.random()*3)+".png")

		}
	}
}

function rotateXAnime(){
	var t = Date.now()-TIME0;
	rotate("circle1",t/1000, t/2000);
	transform_circle("circle1", "r", Math.abs(400*Math.sin(t/1000)));
	window.requestAnimationFrame(rotateXAnime)
}

function main(){
	makeCircle("circle1", "green.png");
	//rotate("circle1", 2);
	window.requestAnimationFrame(rotateXAnime)
}

main();
