
varying vec4 Position;
varying vec4 Position2;
varying float fog;
varying vec4 Normal;
varying vec2 UVs;
varying vec4 Color;
uniform float ttime;
uniform float _dat_x;

varying float fc0;
uniform float beat2;
uniform float PosY;
uniform float Active;

uniform float Slider0;
uniform float Slider1;
uniform float ttimebeat;


vec2 hash(vec2 p) {
	p = vec2(dot(p, vec2(127.1, 311.7)), dot(p, vec2(269.5, 183.3)));
	return -1.0 + 2.0*fract(sin(p)*43758.5453123);
}

float noise(in vec2 p) {
	const float K1 = 0.366025404; // (sqrt(3)-1)/2;
	const float K2 = 0.211324865; // (3-sqrt(3))/6;

	vec2 i = floor(p + (p.x + p.y)*K1);
	vec2 a = p - i + (i.x + i.y)*K2;
	vec2 o = (a.x>a.y) ? vec2(1.0, 0.0) : vec2(0.0, 1.0); //vec2 of = 0.5 + 0.5*vec2(sign(a.x-a.y), sign(a.y-a.x));
	vec2 b = a - o + K2;
	vec2 c = a - 1.0 + 2.0*K2;
	vec3 h = max(0.5 - vec3(dot(a, a), dot(b, b), dot(c, c)), 0.0);
	vec3 n = h*h*h*h*vec3(dot(a, hash(i + 0.0)), dot(b, hash(i + o)), dot(c, hash(i + 1.0)));

	return dot(n, vec3(70.0));
}


mat2 RotationMatrix(float f) {

	mat2 Temp;
	Temp[0][0] = cos(f);
	Temp[1][0] = -sin(f);
	Temp[0][1] = sin(f);
	Temp[1][1] = cos(f);
	return Temp;
};
void main () 
{

	mat2 M = RotationMatrix(ttime);
	UVs = vec2(gl_MultiTexCoord0);
	Color = gl_Color;
	//gl_Position= ftransform ();
	Position.xyzw = gl_Vertex;
	vec3 Normal = gl_Normal.xyz;

	float ft = 1.1*noise(Position.xy*100.02 + vec2(1 + 0.4*ttime));
	float ft2 = 1.0*noise(Position.xz*2.0 + vec2( 0.13+0.0*ttime));
	ft = clamp(ft, 0.0, 1.0);
	ft2 = clamp(ft2, 0.0, 1.0);
	ft2 = pow(1.4*ft2, 30.0)*0.1;
	ft = pow(ft, 10.0)*1.5;
	//ft = pow(ft, 10.0);
	//ft += 1.0;
	//ft = clamp(ft, 0.0, 1.0)*0.03;
	//if (Position.y < 0.575) ft = 0.0;

	fc0 = ft;

	float beat = sin(2 * 3.14159*ttimebeat * 85.0 / 60.0);
	beat = pow(clamp(beat, 0.0, 1.0), 2.0);


	float ftt = 20;
	if (_dat_x < 0.001) ftt = 1000.0;
	else
		ftt = 120.0;

	
	

	float PPosY = clamp (Position.z   +0.1*(ttime-4),0.0,1.0)*10.0;


	ftt = 2.0+PPosY*PPosY;
	if (_dat_x > 0.001) {
		float posy = clamp(PPosY - 14.0, 0.0, 100.0);
		ftt = 226.0 +posy*posy;

	}

	ftt *= 1 - 0.5*beat;
	ftt *= 0.1;
	if (ttime>25) 
		ftt *= 0.6;

	if (ttime>350)
		ftt *= 1000.6;

	if (Slider0 > 0.1)

	{
		ftt = 100.0;
		ft = 0.0;
	}
	if (Slider1 > 0.1)

	{
		ftt = 5.0;
		ft = 0.0;
	}

	Position2 = Position;

//ftt *= PosY*0.1;
	if (Active>0.5) {
		//Color *= 0.2 + 100000.0*ft;

		ft *= 1.0-0.0*clamp(ttime - 18, 0.0, 1.0);
		Position2 = Normal.xyzz*10.0;
		Position.xyz -= abs(Normal.xyz)*10.5*ft*beat;
		
		//t = 5.0;
		//	Position.xy = M*Position.xy;
		//Position.xyz += (-normalize(Position.xyz)-Position.xyz)*0.03;
		vec3 Dir = vec3(1.0)*ttime;
		
//Position.xyz = vec3(ivec3(Position.xyz*ftt + vec3(0, -0.8, -2))) / ftt;

		Position.xyz = vec3(ivec3((Position.xyz + Dir*0.1)*ftt)) / ftt - Dir*0.1;
		Color *= 1+2.0*beat;

		//Position.xyz -= Normal.xyz*ft2;
		//Position.x *= 0.0;

	}
	
	//Position.xyz += gl_Normal.xyz*-0.08;


	gl_Position = gl_ModelViewProjectionMatrix  *Position;
	
	//noise(Position.xy)*100.0;

	Normal.xyz=gl_Normal.xyz;
	//	Position.xyzw= gl_Vertex;



	//Color.xyz = Normal.xyz*0.0;



}
