/*
 * Decompiled with CFR 0.152.
 */
package com.objects;

import com.iceberg.graphics3d.BoundingBox;
import com.iceberg.graphics3d.Graphics3D;
import com.iceberg.graphics3d.Mesh;
import com.iceberg.graphics3d.MeshImage;
import com.iceberg.graphics3d.Morphing;
import com.iceberg.graphics3d.Texture;
import com.iceberg.math.MathUtils;
import com.iceberg.math.Matrix;
import com.iceberg.math.Vector3D;
import com.objects.Bot;
import com.objects.Character;
import com.scene.Asset;
import com.scene.Scene;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;

public class Human
extends Character {
    private static Vector3D dir = new Vector3D();
    private static Vector3D up = new Vector3D();
    private static Vector3D side = new Vector3D();
    private static Vector3D tmpVec = new Vector3D();
    private static int MOVE_SPEED = 50;
    private MeshImage img;
    private BoundingBox boundingBox;
    private int frame;
    private Bot enemy = null;
    private boolean visible = false;
    static /* synthetic */ Class class$com$objects$Bot;

    public Human(Asset asset, int n, int n2, int n3, String string, String string2) {
        try {
            this.setPosition(n, n2, n3);
            Texture texture = asset.getTexture(string2);
            Mesh mesh = asset.getMeshes(string, 400, 400, 400, texture.getWidth())[0];
            mesh.setTexture(texture);
            Morphing morphing = asset.getMorphing(string, 400, 400, 400);
            this.img = new MeshImage(mesh, morphing);
            this.img.setOffsetSZ(220);
            this.boundingBox = new BoundingBox(this.img.getAnimation());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void paintDebug(Graphics3D graphics3D, Graphics graphics, int n, int n2) {
        if (this.visible) {
            int n3 = this.boundingBox.getMinX();
            int n4 = this.boundingBox.getMinY();
            int n5 = this.boundingBox.getMaxX() - n3;
            int n6 = this.boundingBox.getMaxY() - n4;
            graphics.setColor(65280);
            graphics.drawRect(n3 + n, n4 + n2, n5, n6);
        }
    }

    protected void render(Graphics3D graphics3D, int n, int n2, int n3, int n4) {
        Matrix matrix = graphics3D.computeFinalMatrix(this.transform);
        if (this.boundingBox.isVisible(graphics3D, matrix, n, n2, n3, n4)) {
            this.img.setMatrix(matrix);
            graphics3D.addMeshImage(this.img, n, n2, n3, n4);
            this.visible = true;
        }
    }

    public void update(Scene scene) {
        int n;
        super.update(scene);
        this.visible = false;
        this.frame = scene.getFrame();
        if (this.frame % 8 == 0 && this.enemy == null) {
            this.enemy = (Bot)scene.find(class$com$objects$Bot == null ? (class$com$objects$Bot = Human.class$("com.objects.Bot")) : class$com$objects$Bot);
        }
        if (this.enemy != null && (n = this.getTransform().distanceSquared(this.enemy.getTransform())) < MathUtils.squared(5000)) {
            this.lookAt(this.enemy.getTransform().m03, this.enemy.getTransform().m23);
            if (n > MathUtils.squared(500)) {
                this.moveZ(MOVE_SPEED);
                this.img.getAnimation().addFrame(7168 / MOVE_SPEED);
            }
        }
    }

    protected boolean isNeedRecomputePart() {
        if (this.getPart() == -1) {
            return true;
        }
        return this.frame % 5 == 0 && super.isNeedRecomputePart();
    }

    protected void lookAt(int n, int n2) {
        dir.set(this.transform.m02, 0, this.transform.m22);
        tmpVec.set(n - this.transform.m03, 0, n2 - this.transform.m23);
        tmpVec.setLength(16384);
        dir.lerp(dir, tmpVec, 1024);
        Human.setDir(this.transform, Human.dir.x, Human.dir.z);
    }

    private static void setDir(Matrix matrix, int n, int n2) {
        dir.set(n, 0, n2);
        dir.setLength(16384);
        if (Human.equals(Human.dir.x, Human.dir.y, Human.dir.z, matrix.m02, matrix.m12, matrix.m22)) {
            return;
        }
        up.set(0, 16384, 0);
        side.cross(up, dir, 14);
        side.setLength(16384);
        if (dir.lengthSquared() != 0 && side.lengthSquared() != 0) {
            matrix.setDir(Human.dir.x, Human.dir.y, Human.dir.z);
            matrix.setSide(Human.side.x, Human.side.y, Human.side.z);
            matrix.setUp(Human.up.x, Human.up.y, Human.up.z);
        }
    }

    private static boolean equals(int n, int n2, int n3, int n4, int n5, int n6) {
        return Math.abs(n - n4) < 20 && Math.abs(n2 - n5) < 20 && Math.abs(n3 - n6) < 20;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

