/*
 * Decompiled with CFR 0.152.
 */
package com.iceberg.graphics3d;

import javax.microedition.lcdui.Image;

public class Texture {
    boolean perspectiveCorrection = false;
    final int widthBIT;
    final int w;
    final int h;
    int[] pixels;
    String name;

    private Texture(Image image) throws Exception {
        this.w = image.getWidth();
        this.h = image.getHeight();
        this.widthBIT = this.widthToBIT(this.w);
        this.pixels = new int[this.w * this.h];
        image.getRGB(this.pixels, 0, this.w, 0, 0, this.w, this.h);
    }

    public Texture(int[] nArray, int n, int n2) {
        this.pixels = nArray;
        this.w = n;
        this.h = n2;
        this.widthBIT = this.widthToBIT(n);
    }

    private int widthToBIT(int n) {
        for (int i = 0; i < 32; ++i) {
            if (n >> i != 1 || 1 << i != n) continue;
            return i;
        }
        return 0;
    }

    public void setPerspectiveCorrection(boolean bl) {
        this.perspectiveCorrection = bl;
    }

    public boolean getPerspectiveCorrection() {
        return this.perspectiveCorrection;
    }

    public int getWidth() {
        return this.w;
    }

    public int getHeight() {
        return this.h;
    }

    public int[] getPixels() {
        return this.pixels;
    }

    public static Texture createTexture(String string) {
        try {
            Texture texture = new Texture(Image.createImage((String)string));
            texture.name = string;
            return texture;
        }
        catch (Exception exception) {
            System.err.println("ERROR in createTexture " + string + ": " + exception);
            return null;
        }
    }

    public void destroy() {
        this.pixels = null;
    }

    public static Texture createTexture(Image image) {
        try {
            return new Texture(image);
        }
        catch (Exception exception) {
            System.err.println("ERROR in createTexture: " + exception);
            return null;
        }
    }

    public static Texture createTexture(int[] nArray, int n, int n2) {
        try {
            return new Texture(nArray, n, n2);
        }
        catch (Exception exception) {
            System.err.println("ERROR in createTexture: " + exception);
            return null;
        }
    }

    public static Texture createCopyTexture(Texture texture) {
        try {
            int[] nArray = new int[texture.pixels.length];
            System.arraycopy(texture.pixels, 0, nArray, 0, nArray.length);
            return new Texture(nArray, texture.w, texture.h);
        }
        catch (Exception exception) {
            System.err.println("ERROR in createTexture: " + exception);
            return null;
        }
    }
}

