/*
 * Decompiled with CFR 0.152.
 */
package com.iceberg.graphics3d;

import com.demo.Main;
import com.iceberg.graphics3d.Mesh;
import com.iceberg.graphics3d.MeshImage;
import com.iceberg.graphics3d.RenderObjectBuffer;
import com.iceberg.graphics3d.Sprite;
import com.iceberg.graphics3d.SpriteAdd;
import com.iceberg.graphics3d.TMPElement;
import com.iceberg.graphics3d.Vertex;
import com.iceberg.math.Matrix;
import javax.microedition.lcdui.Graphics;

public class Graphics3D {
    public int width;
    public int height;
    public int[] display;
    public RenderObjectBuffer buffer = new RenderObjectBuffer();
    private int distX = 150;
    private int distY = 150;
    private int centreX;
    private int centreY;
    private Matrix camera = new Matrix();
    private Matrix invCamera = new Matrix();
    private Matrix finalCamera = new Matrix();
    public static int drawDist = 216000;

    public Graphics3D(int n, int n2) {
        this.width = n;
        this.height = n2;
        this.display = new int[this.width * this.height];
        this.centreX = this.width / 2;
        this.centreY = this.height / 2;
        this.setPerspective(8500);
    }

    public Graphics3D(int n, int n2, float f) {
        this.width = n;
        this.height = n2 * Main.quality / 100;
        this.display = new int[this.width * this.height];
        this.centreX = this.width / 2;
        this.centreY = this.height / 2;
        this.setPerspective(8500, f);
    }

    public void resize(int n, int n2) {
        this.width = this.width;
        this.height = this.height * Main.quality / 100;
        this.display = new int[this.width * this.height];
        this.centreX = this.width / 2;
        this.centreY = this.height / 2;
        this.setPerspective(8500);
    }

    public void setPerspective(int n) {
        this.setPerspective(n, 1.0f);
    }

    public void setPerspective(int n, float f) {
        if (!Main.landspace) {
            this.distX = this.centreX * n >> 12;
            this.distY = this.centreY * 100 / Main.quality * n >> 12;
            this.distX = (int)((float)this.distX / (Main.aspectRatio / f));
        } else {
            this.distX = this.centreX * n >> 12;
            this.distY = this.centreY * n >> 12;
            this.distY = (int)((float)this.distY * (Main.aspectRatio / f));
        }
    }

    public void setCamera(Matrix matrix) {
        this.camera.set(matrix);
        this.invCamera.set(matrix);
        this.invCamera.invert();
    }

    public Matrix getCamera() {
        return this.camera;
    }

    public Matrix getInvCamera() {
        return this.invCamera;
    }

    public Matrix computeFinalMatrix(Matrix matrix) {
        this.finalCamera.mul(this.invCamera, matrix);
        return this.finalCamera;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void addMesh(Mesh mesh) {
        this.addMesh(mesh, 0, 0, this.width, this.height);
    }

    public void addMesh(Mesh mesh, int n, int n2, int n3, int n4) {
        this.buffer.addRenderObjects(mesh.getPolygons(), mesh.getTexture(), n, n2, n3, n4);
    }

    public void addSprite(Sprite sprite) {
        this.addSprite(sprite, 0, 0, this.width, this.height);
    }

    public void addSprite(Sprite sprite, int n, int n2, int n3, int n4) {
        this.buffer.addRenderObject(sprite, n, n2, n3, n4);
    }

    public void addSpriteAdd(SpriteAdd spriteAdd) {
        this.addSpriteAdd(spriteAdd, 0, 0, this.width, this.height);
    }

    public void addSpriteAdd(SpriteAdd spriteAdd, int n, int n2, int n3, int n4) {
        this.buffer.addRenderObject(spriteAdd, n, n2, n3, n4);
    }

    public void addRenderObject(TMPElement tMPElement, int n, int n2, int n3, int n4) {
        this.buffer.addRenderObject(tMPElement, n, n2, n3, n4);
    }

    public void addRenderObject(TMPElement tMPElement) {
        this.buffer.addRenderObject(tMPElement, 0, 0, this.width, this.height);
    }

    public void addMeshImage(MeshImage meshImage) {
        this.addMeshImage(meshImage, 0, 0, this.width, this.height);
    }

    public void addMeshImage(MeshImage meshImage, int n, int n2, int n3, int n4) {
        this.buffer.addRenderObject(meshImage, n, n2, n3, n4);
    }

    public void render() {
        this.buffer.sort();
        TMPElement[] tMPElementArray = this.buffer.getBuffer();
        for (int i = this.buffer.getSize() - 1; i >= 0; --i) {
            TMPElement tMPElement = tMPElementArray[i];
            tMPElement.obj.render(this, tMPElement.tex);
        }
        this.buffer.reset();
    }

    public void flush(Graphics graphics, int n, int n2, int n3) {
        graphics.drawRGB(this.display, 0, this.width, n, n2, this.width, this.height, false);
    }

    public void clear(int n, int n2) {
        int n3;
        int[] nArray = this.display;
        for (n3 = n2 - 1; n3 >= 4; n3 -= 4) {
            nArray[n3] = n;
            nArray[n3 - 1] = n;
            nArray[n3 - 2] = n;
            nArray[n3 - 3] = n;
        }
        while (n3 >= 0) {
            nArray[n3] = n;
            --n3;
        }
    }

    public void clear(int n) {
        this.clear(n, this.display.length);
    }

    public void project(Vertex vertex) {
        if (vertex.rz <= 0) {
            vertex.sx = vertex.sx * this.distX / (-vertex.rz + this.distX) + this.centreX;
            vertex.sy = -vertex.sy * this.distY / (-vertex.rz + this.distY) + this.centreY;
        } else {
            vertex.sx += this.centreX;
            vertex.sy = -vertex.sy + this.centreY;
        }
    }

    public void project(Vertex[] vertexArray) {
        int n = this.centreX;
        int n2 = this.centreY;
        int n3 = this.distX;
        int n4 = this.distY;
        Vertex vertex = null;
        if (!Main.landspace) {
            for (int i = vertexArray.length - 1; i >= 0; --i) {
                vertex = vertexArray[i];
                int n5 = vertex.sx;
                int n6 = -vertex.sy;
                int n7 = vertex.rz;
                if (n7 <= 0) {
                    n5 = n5 * n3 / (-n7 + n3);
                    n6 = n6 * n4 / (-n7 + n4);
                }
                vertex.sx = n5 + n;
                vertex.sy = n6 + n2;
                vertex.rz = n7;
            }
        } else {
            for (int i = vertexArray.length - 1; i >= 0; --i) {
                vertex = vertexArray[i];
                int n8 = vertex.sx;
                int n9 = -vertex.sy;
                int n10 = vertex.rz;
                if (n10 <= 0) {
                    n8 = n8 * n3 / (-n10 + n3);
                    n9 = n9 * n4 / (-n10 + n4);
                }
                vertex.sx = this.height - n9 - this.height + this.centreX;
                vertex.sy = this.width - n8 - this.width + this.centreY;
                vertex.rz = n10;
            }
        }
    }

    public void transformAndProjectVertices(Vertex[] vertexArray, Matrix matrix) {
        int n = this.distX;
        int n2 = this.distY;
        int n3 = this.centreX;
        int n4 = this.centreY;
        int n5 = matrix.m00 >> 2;
        int n6 = matrix.m01 >> 2;
        int n7 = matrix.m02 >> 2;
        int n8 = matrix.m03;
        int n9 = matrix.m10 >> 2;
        int n10 = matrix.m11 >> 2;
        int n11 = matrix.m12 >> 2;
        int n12 = matrix.m13;
        int n13 = matrix.m20 >> 2;
        int n14 = matrix.m21 >> 2;
        int n15 = matrix.m22 >> 2;
        int n16 = matrix.m23;
        Vertex vertex = null;
        if (!Main.landspace) {
            for (int i = vertexArray.length - 1; i >= 0; --i) {
                vertex = vertexArray[i];
                int n17 = vertex.x;
                int n18 = vertex.y;
                int n19 = vertex.z;
                int n20 = (n17 * n5 >> 12) + (n18 * n6 >> 12) + (n19 * n7 >> 12) + n8;
                int n21 = -((n17 * n9 >> 12) + (n18 * n10 >> 12) + (n19 * n11 >> 12) + n12);
                int n22 = (n17 * n13 >> 12) + (n18 * n14 >> 12) + (n19 * n15 >> 12) + n16;
                if (n22 < 0) {
                    n20 = n20 * n / (n - n22);
                    n21 = n21 * n2 / (n2 - n22);
                }
                vertex.sx = n20 + n3;
                vertex.sy = n21 + n4;
                vertex.rz = n22;
            }
        } else {
            for (int i = vertexArray.length - 1; i >= 0; --i) {
                vertex = vertexArray[i];
                int n23 = vertex.x;
                int n24 = vertex.y;
                int n25 = vertex.z;
                int n26 = n8;
                if (n5 != 0) {
                    n26 += n23 * n5 >> 12;
                }
                if (n6 != 0) {
                    n26 += n24 * n6 >> 12;
                }
                if (n7 != 0) {
                    n26 += n25 * n7 >> 12;
                }
                int n27 = n12;
                if (n9 != 0) {
                    n27 += n23 * n9 >> 12;
                }
                if (n10 != 0) {
                    n27 += n24 * n10 >> 12;
                }
                if (n11 != 0) {
                    n27 += n25 * n11 >> 12;
                }
                int n28 = n16;
                if (n13 != 0) {
                    n28 += n23 * n13 >> 12;
                }
                if (n14 != 0) {
                    n28 += n24 * n14 >> 12;
                }
                if (n15 != 0) {
                    n28 += n25 * n15 >> 12;
                }
                if (n28 <= 0) {
                    n26 = n26 * n2 / (-n28 + n2);
                    n27 = n27 * n / (-n28 + n);
                }
                vertex.sx = this.height - n27 - this.height + this.centreX;
                vertex.sy = this.width - n26 - this.width + this.centreY;
                vertex.rz = n28;
            }
        }
    }

    public final void destroy() {
        this.finalCamera = null;
        this.invCamera = null;
        this.camera = null;
        this.display = null;
        this.buffer = null;
    }

    public void setDrawDist(int n) {
        drawDist = n;
    }
}

