/*
 * Decompiled with CFR 0.152.
 */
package com.gameutils.textutils;

import java.io.InputStream;
import java.util.Vector;

public class TextUtils {
    public static String getStringFromResource(String string) {
        InputStream inputStream = null;
        try {
            inputStream = new Object().getClass().getResourceAsStream(string);
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            while ((n = inputStream.read()) != -1) {
                if (n == 13) continue;
                n = n >= 192 && n <= 255 ? n + 848 : n;
                stringBuffer.append((char)n);
            }
            inputStream.close();
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            System.out.println("ERROR in getStr: " + exception);
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
            return null;
        }
    }

    private static Vector scissors(String string, char c) {
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while (n < string.length()) {
            while (n < string.length() && string.charAt(n) == c) {
                ++n;
            }
            int n2 = n;
            while (n < string.length() && string.charAt(n) != c) {
                ++n;
            }
            int n3 = n;
            if (n2 >= n3) continue;
            String string2 = string.substring(n2, n3);
            vector.addElement(string2);
        }
        return vector;
    }

    public static String[] cutOnString(String string, char c) {
        Vector vector = TextUtils.scissors(string, c);
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public static byte[] cutOnByte(String string, char c) {
        Vector vector = TextUtils.scissors(string, c);
        byte[] byArray = new byte[vector.size()];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = (byte)TextUtils.parseInt((String)vector.elementAt(i));
        }
        return byArray;
    }

    public static int[] cutOnInt(String string, char c) {
        Vector vector = TextUtils.scissors(string, c);
        int[] nArray = new int[vector.size()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = TextUtils.parseInt((String)vector.elementAt(i));
        }
        return nArray;
    }

    public static float[] cutOnFloat(String string, char c) {
        Vector vector = TextUtils.scissors(string, c);
        float[] fArray = new float[vector.size()];
        for (int i = 0; i < fArray.length; ++i) {
            fArray[i] = TextUtils.parseFloat((String)vector.elementAt(i));
        }
        return fArray;
    }

    public static int parseInt(String string) {
        string = TextUtils.deleteExtremeSpaces(string);
        return Integer.parseInt(string);
    }

    public static byte parseByte(String string) {
        string = TextUtils.deleteExtremeSpaces(string);
        return (byte)Integer.parseInt(string);
    }

    public static float parseFloat(String string) {
        string = TextUtils.deleteExtremeSpaces(string);
        return Float.parseFloat(string);
    }

    public static String deleteExtremeSpaces(String string) {
        while (string.length() > 0 && string.charAt(0) == ' ') {
            string = string.substring(1, string.length());
        }
        while (string.length() > 0 && string.charAt(string.length() - 1) == ' ') {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    public static String deleteAllSpaces(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == ' ') continue;
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }
}

