/*
 * Decompiled with CFR 0.152.
 */
package com.gameutils.gui;

import com.gameutils.gui.MyFont;
import com.gameutils.mycanvas.Keyboard;
import com.gameutils.mycanvas.MyCanvas;
import javax.microedition.lcdui.Graphics;

public abstract class GUIScreen
extends MyCanvas {
    private static final int SOFT_HEIGHT = 10;
    private String left;
    private String right;
    private MyFont font;
    private int pressX = 0;
    private int pressY = 0;

    public void destroy() {
        this.right = null;
        this.left = null;
        this.font = null;
    }

    protected void init(MyFont myFont, String string, String string2) {
        this.setFont(myFont);
        this.setSoftName(string, string2);
    }

    protected void setFont(MyFont myFont) {
        this.font = myFont;
    }

    protected MyFont getFont() {
        return this.font;
    }

    protected void setSoftName(String string, String string2) {
        this.left = string;
        this.right = string2;
    }

    protected void setLeftSoftName(String string) {
        this.left = string;
    }

    protected void setRightSoftName(String string) {
        this.right = string;
    }

    protected void drawSoftName(Graphics graphics) {
        int n = this.getWidth();
        int n2 = this.getHeight();
        if (this.left != null) {
            this.font.drawString(graphics, this.left, 2, n2, 36);
        }
        if (this.right != null) {
            this.font.drawString(graphics, this.right, n - 2, n2, 40);
        }
    }

    protected final void keyPressed(int n) {
        Keyboard keyboard = this.getKeyboard();
        if (n == keyboard.SOFT_LEFT) {
            this.leftSoftPressed();
        }
        if (n == keyboard.SOFT_RIGHT) {
            this.rightSoftPressed();
        }
        if (n == 53 || n == keyboard.FIRE) {
            this.firePressed();
        }
        if (n == 52 || n == keyboard.LEFT) {
            this.leftPressed();
        }
        if (n == 54 || n == keyboard.RIGHT) {
            this.rightPressed();
        }
        if (n == 50 || n == keyboard.UP) {
            this.upPressed();
        }
        if (n == 56 || n == keyboard.DOWN) {
            this.downPressed();
        }
    }

    protected void leftSoftPressed() {
    }

    protected void rightSoftPressed() {
    }

    protected void firePressed() {
    }

    protected void leftPressed() {
    }

    protected void rightPressed() {
    }

    protected void upPressed() {
    }

    protected void downPressed() {
    }

    protected void pointerPressed(int n, int n2) {
        this.pressX = n;
        this.pressY = n2;
        Keyboard keyboard = this.getKeyboard();
        if (GUIScreen.isPointOnLeftSoft(n, n2, this.getWidth(), this.getHeight())) {
            this.keyPressed(keyboard.SOFT_LEFT);
        }
        if (GUIScreen.isPointOnRightSoft(n, n2, this.getWidth(), this.getHeight())) {
            this.keyPressed(keyboard.SOFT_RIGHT);
        }
    }

    protected void pointerDragged(int n, int n2) {
        int n3 = this.getWidth();
        int n4 = this.getHeight();
        if (Math.abs(this.pressX - n) > n3 / 7) {
            if (this.pressX < n) {
                this.rightPressed();
            }
            if (this.pressX > n) {
                this.leftPressed();
            }
            this.pressX = n;
        }
        if (Math.abs(this.pressY - n2) > n4 / 7) {
            if (this.pressY > n2) {
                this.upPressed();
            }
            if (this.pressY < n2) {
                this.downPressed();
            }
            this.pressY = n2;
        }
    }

    public static boolean isPointOnLeftSoft(int n, int n2, int n3, int n4) {
        int n5 = n4 / 10;
        return GUIScreen.isPointInRect(n, n2, 0, n4 - n5, n3 / 2 - n3 / 6, n4);
    }

    public static boolean isPointOnRightSoft(int n, int n2, int n3, int n4) {
        int n5 = n4 / 10;
        return GUIScreen.isPointInRect(n, n2, n3 / 2 + n3 / 6, n4 - n5, n3, n4);
    }

    public static boolean isPointOnSelect(int n, int n2, int n3, int n4) {
        int n5 = n4 / 10;
        return GUIScreen.isPointInRect(n, n2, n3 / 2 - n3 / 6, n4 - n5, n3 / 2 + n3 / 6, n4);
    }

    private static boolean isPointInRect(int n, int n2, int n3, int n4, int n5, int n6) {
        return n >= n3 && n <= n5 && n2 >= n4 && n2 <= n6;
    }
}

