/*
 * Decompiled with CFR 0.152.
 */
package com.petterroea.mousebutton;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import nl.captcha.Captcha;

class RenderPanel
extends JPanel
implements KeyListener {
    private int mode = 0;
    Captcha captcha;
    private StringBuilder sb = new StringBuilder();

    public RenderPanel() {
        final RenderPanel me = this;
        this.captcha = new Captcha.Builder(200, 50).addText().addNoise().build();
        this.requestFocus();
        this.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent arg0) {
                if (RenderPanel.this.mode == 0) {
                    RenderPanel renderPanel = RenderPanel.this;
                    renderPanel.mode = renderPanel.mode + 1;
                }
                if (RenderPanel.this.mode == 2) {
                    JOptionPane.showMessageDialog(null, "Congratulations, your mouse button (probably) works!", "SUCCESS", 1);
                }
                me.paint(me.getGraphics());
            }

            @Override
            public void mouseEntered(MouseEvent arg0) {
            }

            @Override
            public void mouseExited(MouseEvent arg0) {
            }

            @Override
            public void mousePressed(MouseEvent arg0) {
            }

            @Override
            public void mouseReleased(MouseEvent arg0) {
            }
        });
    }

    @Override
    public void paint(Graphics g) {
        if (this.mode == 0) {
            this.renderLicenceAgreement(g);
        } else if (this.mode == 1) {
            this.renderCapchaTest(g);
        } else if (this.mode == 2) {
            this.renderTest(g);
        } else if (this.mode == 3) {
            this.renderRobotDetectedScreen(g);
        }
    }

    private void renderTest(Graphics g) {
        g.setColor(Color.BLACK);
        g.fillRect(0, 0, 400, 140);
        g.setColor(Color.white);
        g.drawString("Please click anywhere on the screen to verify the ", 0, 10);
        g.drawString("operability of your mouse button", 0, 25);
    }

    public void renderRobotDetectedScreen(Graphics g) {
        g.setColor(Color.RED);
        g.fillRect(0, 0, 400, 140);
        g.setColor(Color.white);
        g.setFont(g.getFont().deriveFont(80.0f));
        g.drawString("!", 0, 90);
        g.drawString("!", 360, 90);
        g.setFont(g.getFont().deriveFont(20.0f));
        g.drawString("ROBOT DETECTED", 45, 40);
        g.setFont(g.getFont().deriveFont(15.0f));
        g.drawString("This test is not designed for robots...", 45, 60);
        g.drawString("(...please leave)", 45, 78);
    }

    private void renderCapchaTest(Graphics g) {
        g.setColor(Color.BLACK);
        g.fillRect(0, 0, 400, 140);
        g.setColor(Color.white);
        g.drawString("Please verify that you are human...", 0, 10);
        g.setColor(Color.white);
        g.fillRect(0, 30, 200, 50);
        g.drawString(this.sb.toString(), 210, 55);
        g.drawImage(this.captcha.getImage(), 0, 30, null);
        g.drawString("Press enter to verify", 0, 90);
    }

    public void renderLicenceAgreement(Graphics g) {
        g.setColor(Color.BLACK);
        g.fillRect(0, 0, 400, 140);
        g.setColor(Color.white);
        g.drawString("Usage of this software is at own risk", 0, 10);
        g.drawString("While this software is meant to be usefull, there is no", 0, 25);
        g.drawString("guarantee the measurements are accurate. Use at own risk.", 0, 40);
        g.drawString("Click anywhere to proceed", 0, 65);
    }

    @Override
    public void keyPressed(KeyEvent arg0) {
        if (arg0.getKeyCode() == 10) {
            System.out.println("We want: " + this.captcha.getAnswer());
            this.mode = this.sb.toString().equals(this.captcha.getAnswer()) ? 2 : 3;
            this.paint(this.getGraphics());
        }
    }

    @Override
    public void keyReleased(KeyEvent arg0) {
    }

    @Override
    public void keyTyped(KeyEvent arg0) {
        if (this.mode == 1) {
            System.out.println("Got press " + arg0.getKeyChar());
            this.sb.append(arg0.getKeyChar());
            this.paint(this.getGraphics());
        }
    }
}

