attribute vec3 position;
attribute vec2 uvCoord0;

uniform mat4 vpMat;
uniform mat4 mMat;
uniform float time;

varying vec3 vPos;

void main()
{
	vec3 pos = position;
	pos.y = pos.y * 20 - 80.;
	vec2 zDiv = vec2(12, 8);

	if(time < 80)
	{
		pos.z += cos(time + pos.y / zDiv.x)*0.8;
		pos.x += sin(time + pos.z / zDiv.y)*0.45;
	}
	else
	{
		zDiv = vec2(4, 4);
		pos.x += cos(time + pos.y / zDiv.x)*0.6;
		pos.y += sin(time + pos.z / zDiv.y)*0.6;
	}

	gl_Position = vpMat * mMat * vec4(pos, 1.0);

	vPos = pos;
}
