//Mainly code that I've just taken from the internet!
//http://stackoverflow.com/questions/986937/javascript-get-the-browsers-scrollbar-sizes
function getScrollBarWidth () {
  var inner = document.createElement('p');
  inner.style.width = "100%";
  inner.style.height = "200px";

  var outer = document.createElement('div');
  outer.style.position = "absolute";
  outer.style.top = "0px";
  outer.style.left = "0px";
  outer.style.visibility = "hidden";
  outer.style.width = "200px";
  outer.style.height = "150px";
  outer.style.overflow = "hidden";
  outer.appendChild (inner);

  document.body.appendChild (outer);
  var w1 = inner.offsetWidth;
  outer.style.overflow = 'scroll';
  var w2 = inner.offsetWidth;
  if (w1 == w2) w2 = outer.clientWidth;

  document.body.removeChild (outer);

  return (w1 - w2);
};

//http://stackoverflow.com/questions/1255512/how-to-draw-a-rounded-rectangle-on-html-canvas
CanvasRenderingContext2D.prototype.roundRect = function (x, y, w, h, r) {
  if (w < 2 * r) r = w / 2;
  if (h < 2 * r) r = h / 2;
  this.beginPath();
  this.moveTo(x+r, y);
  this.arcTo(x+w, y,   x+w, y+h, r);
  this.arcTo(x+w, y+h, x,   y+h, r);
  this.arcTo(x,   y+h, x,   y,   r);
  this.arcTo(x,   y,   x+w, y,   r);
  this.closePath();
  return this;
}


function dumpobj(obj){
	console.log(JSON.stringify(obj, null, 4));
}


//Mod of: https://raw.githubusercontent.com/hughsk/triangle-normal/master/index.js
function triangleNormal(v0, v1, v2, output) {
	if (!output) output = [];

	var p1x = v1[0] - v0[0];
	var p1y = v1[1] - v0[1];
	var p1z = v1[2] - v0[2];

	var p2x = v2[0] - v0[0];
	var p2y = v2[1] - v0[1];
	var p2z = v2[2] - v0[2];

	var p3x = p1y * p2z - p1z * p2y;
	var p3y = p1z * p2x - p1x * p2z;
	var p3z = p1x * p2y - p1y * p2x;

	var mag = Math.sqrt(p3x * p3x + p3y * p3y + p3z * p3z);
	if (mag === 0) {
		output[0] = 0;
		output[1] = 0;
		output[2] = 0;
	} else {
		output[0] = p3x / mag;
		output[1] = p3y / mag;
		output[2] = p3z / mag;
	}

	return output;
}
