#version 330
layout (location = 0) out vec4 FragColor;
layout (location = 1) out vec4 BrightColor;

in vec2 texcoord;

uniform sampler2D smallimg;
uniform sampler2D bigimg;

uniform float time;

const vec4 black = vec4(0.0, 0.0, 0.0, 1.0);

void main(){
   vec4 tc1 = texture(smallimg, texcoord + vec2(-time / 100.0, time / 90.0));
   vec4 tc2 = texture(bigimg,   texcoord + vec2(-time / 50.0,  time / 40.0));
   
   FragColor   = max(tc1, tc2);
   BrightColor = max(tc1, tc2);
}