#version 410 core

uniform mat4 Proj;
uniform mat4 View;
uniform mat4 World;

layout(location = 0) in vec3 VertexPosition;
layout(location = 1) in vec3 VertexNormal;

out vec3 Color;
out vec3 WorldPos;
out vec3 WorldNormal;

void main()
{
    Color = vec3(1.0);
    WorldPos = (World * vec4(VertexPosition, 1.0)).xyz;

    // TODO: Pass as uniform instead
    mat4 worldNormalMatrix = transpose(inverse(World));
    WorldNormal = normalize(worldNormalMatrix * vec4(VertexNormal, 0.0)).xyz;

    gl_Position = Proj * View * vec4(WorldPos, 1.0);
}
