#version 410 core

uniform vec2 resolution;
uniform sampler2D farColorTex;
uniform sampler2D cocTex;

uniform float polygonSides;
uniform float polygonAmount;

in vec2 texCoords;

out vec4 FragColor;

vec2 unitSquareToNGon(vec2 p, float n, float amount)
{
    float a = p.x * 2.0 - 1.0;
    float b = p.y * 2.0 - 1.0;

    float pi = 3.141592;

    float r, theta;
    if (a > -b)
    {
        if (a > b)
        {
            r = a;
            theta = (pi / 4.0) * (b / a);
        }
        else
        {
            r = b;
            theta = (pi / 4.0) * (2.0 - (a / b));
        }
    }
    else
    {
        if (a < b)
        {
            r = -a;
            theta = (pi / 4.0) * (4.0 + (b / a));
        }
        else
        {
            r = -b;
            if (b != 0.0)
            {
                theta = (pi / 4.0) * (6.0 - (a / b));
            }
            else
            {
                theta = 0.0;
            }
        }
    }

    r *= mix(1.0, cos(pi / n) / cos(theta - (2.0 * pi / n) * floor((n * theta + pi) / (2.0 * pi))), amount);
    // This is just so that the shape isn't aligned to an axis, which looks a bit nicer
    theta += .6;

    float u = r * cos(theta);
    float v = r * sin(theta);
    return vec2(u, v);
}

void main()
{
    vec2 currentPixelUv = texCoords;
    float currentPixelCoc = texture(cocTex, currentPixelUv).x;
    vec3 currentPixelColor = texture(farColorTex, currentPixelUv).xyz;

    vec3 color = currentPixelColor;

    if (currentPixelCoc < 0.0)
    {
        // Flood fill with in-focus pixel rejection
        const int blurRes = 3;
        for (int y = 0; y < blurRes; y++)
        {
            for (int x = 0; x < blurRes; x++)
            {
                vec2 unitSquareOffset = vec2(float(x), float(y)) / float(blurRes - 1);
                vec2 nGonOffset = unitSquareToNGon(unitSquareOffset, polygonSides, polygonAmount);
                vec2 offset = nGonOffset * -currentPixelCoc * float(blurRes / 2);
                vec2 uv = texCoords + offset / resolution;

                float coc = texture(cocTex, uv).x;
                if (coc < 0.0)
                {
                    float weight = coc <= currentPixelCoc ? 1.0 : -coc;
                    color = max(color, texture(farColorTex, uv).xyz * weight);
                }
            }
        }
    }

    FragColor = vec4(color, 1.0);
}
