#version 410 core

uniform vec2 resolution;
uniform float focusDepth;
uniform float focusRange;

uniform sampler2D posTex;

in vec2 texCoords;

out vec4 FragColor;

void main()
{
    ivec2 uv = ivec2(texCoords * resolution);

    const float minCoc = 0.0;
    const float maxCoc = 1.0;
    float coc = -maxCoc;

    vec3 worldPos = texelFetch(posTex, uv, 0).xyz;
    // TODO: Better check than this (because it can fail with valid values)
    if (worldPos != vec3(0.0))
    {
        float linearDepth = worldPos.z;
        float relativeDepth = linearDepth - focusDepth;
        float absRelativeDepth = abs(relativeDepth);
        if (absRelativeDepth >= focusRange)
        {
            coc = maxCoc * sign(relativeDepth);
        }
        else
        {
            float f = absRelativeDepth / focusRange;
            coc = mix(minCoc, maxCoc, f) * sign(relativeDepth);
        }
    }

    FragColor = vec4(coc, 0.0, 0.0, 1.0);
}
