#version 410 core

uniform vec2 resolution;
uniform sampler2D tex;

uniform float direction;

in vec2 texCoords;

out vec4 FragColor;

void main()
{
    vec3 acc = vec3(0.0);

    const int steps = 3;
    const float weights[steps] = float[steps](0.27343750, 0.32812500, 0.03515625);
    const float offsets[steps] = float[steps](0.00000000, 1.33333333, 3.11111111);

    acc += texture(tex, texCoords).xyz * weights[0];

    for (int i = 1; i < steps; i++)
    {
        vec2 offset = mix(vec2(1.0, 0.0), vec2(0.0, 1.0), direction) * offsets[i] / resolution;
        acc +=
            (texture(tex, texCoords - offset).xyz +
             texture(tex, texCoords + offset).xyz) * weights[i];
    }

    FragColor = vec4(acc, 1.0);
}
