
var screen = document.getElementById( 'demo' );

// Preload
var graphics = [
	'gfx/Logo.png',
	'gfx/phase1_bg.png',
	'gfx/phase1_doggy.png',
	'gfx/phase1_doggy_lazy.png',
	'gfx/phase1_doggy_puf1.png',
	'gfx/phase1_doggy_puf2.png',
	'gfx/phase1_pillow.png',
	//
	'gfx/phase2_bgforest.png',
	'gfx/phase2_doganim.gif',
	//
	'gfx/phase3_flydog.gif',
	//
	'gfx/phase4_TheEnd.png'
];
for( var a = 0; a < graphics.length; a++ )
{
	var g = new Image();
	g.src = graphics[a];
	graphics[a] = g;
}
// Done preload

var phases = [
	{
		time: 11.5,
		background: '#000000',
		prog: scene1
	},
	{
		time: 15,
		background: '#000000',
		prog: scene2
	},
	{
		time: 15,
		background: '#000000',
		prog: scene3
	},
	{
		time: 17,
		background: '#000000',
		prog: scene4
	}
];

var prevPhase = false;
var currentPhase = 0;

function RunDemo()
{
	//console.log( 'Current phase = ' + currentPhase );
	if( phases[ prevPhase ] )
	{
		var o = phases[ prevPhase ];
		screen.style.background = o.background;
	
		// clean out disposables
		if( o.disposables )
		{
			for( var b = 0; b < o.disposables.length; b++ )
			{
				o.disposables[b].parentNode.removeChild( o.disposables[b] );
			}
		}
		o.disposables = [];
		if( o.cleanup ) o.cleanup();
	}

	var o = phases[ currentPhase ];
	
	if( o && typeof( o.prog ) != 'undefined' ) o.prog( o, true );
	
	if( currentPhase + 1 > phases.length )
	{
		var audio = document.getElementsByTagName( 'audio' )[0];
		var volume = 1;
		function fade()
		{
			if( volume > 0 )
			{
				volume -= 0.01;
				setTimeout( function(){ fade() }, 50 );
			}
			if( volume < 0 ) volume = 0;
			audio.volume = volume;
		}
		fade();
		return;
	}
	
	setTimeout( RunDemo, o.time * 1000 );
	prevPhase = currentPhase;
	currentPhase++;
}

function scene1( o, init )
{
	// Initialize!
	if( init )
	{
		o.step = 0;
		
		o.timer = ( new Date() ).getTime();
		o.disposables = [];
		
		// Setup background
		var bg = document.createElement( 'div' );
		bg.className = 'background pixelled';
		bg.style.backgroundImage = 'url(' + graphics[1].src + ')';
		bg.style.opacity = 0;
		o.bg = bg;
		screen.appendChild( bg );
		o.disposables.push( bg );
		
		// Pillow
		var pillow = document.createElement( 'div' );
		pillow.className = 'pixelled pillow';
		pillow.style.backgroundImage = 'url(' + graphics[6].src + ')';
		o.pillow = pillow;
		bg.appendChild( pillow );
		o.disposables.push( pillow );
		
		// Create dog
		var dog = document.createElement( 'div' );
		dog.className = 'pixelled dog';
		dog.style.backgroundImage = 'url(' + graphics[2].src + ')';
		bg.appendChild( dog );
		dog.style.left = '0';
		dog.style.top = '0';
		o.dog = dog;
		
		o.interval = setInterval( function(){ scene1( o ); }, 25 );
		o.cleanup = function()
		{
			clearInterval( this.interval );
			this.interval = false;
		}
		return;
	}
	
	// We have initialized
	var phase = ( new Date() ).getTime() - o.timer;
	
	// Make sure the background is faded in
	if( o.bg.style.opacity == 0 && o.step == 0 )
	{
		o.bg.style.opacity = 1;
	}
	
	if( phase > 1000 && !o.logo )
	{
		var logo = document.createElement( 'div' );
		logo.className = 'pixelled logo';
		logo.style.backgroundImage = 'url(' + graphics[0].src + ')';
		logo.style.top = '-200px';
		logo.style.left = '153px';
		o.bg.appendChild( logo );
		o.logo = logo;
		o.disposables.push( logo );
		setTimeout( function(){ logo.style.top = '65px'; }, 50 );
	}
	if( phase > 2000 && o.step == 0 )
	{
		o.step++;
		o.dog.style.backgroundImage = 'url(' + graphics[3].src + ')';
	}
	else if( phase > 2500 && o.step == 1 )
	{
		o.step++;
		o.dog.style.backgroundImage = 'url(' + graphics[4].src + ')';
	}
	else if( phase > 3000 && o.step == 2 )
	{
		o.step++;
		o.dog.style.backgroundImage = 'url(' + graphics[3].src + ')';
	}
	else if( phase > 3500 && o.step == 3 )
	{
		o.step++;
		o.dog.style.backgroundImage = 'url(' + graphics[4].src + ')';
	}
	else if( phase > 4000 && o.step == 4 )
	{
		o.step++;
		o.dog.style.backgroundImage = 'url(' + graphics[3].src + ')';
	}
	else if( phase > 4500 && o.step == 5 )
	{
		o.step++;
		o.dog.style.backgroundImage = 'url(' + graphics[4].src + ')';
	}
	else if( phase > 5000 && o.step == 6 )
	{
		o.step++;
		o.dog.style.backgroundImage = 'url(' + graphics[3].src + ')';
	}
	else if( phase > 5500 && o.step == 7 )
	{
		o.step++;
		o.dog.style.backgroundImage = 'url(' + graphics[4].src + ')';
	}
	else if( phase > 6000 && o.step == 8 )
	{
		o.step++;
		o.dog.style.backgroundImage = 'url(' + graphics[3].src + ')';
	}
	else if( phase > 6500 && o.step == 9 )
	{
		o.step++;
		o.dog.style.backgroundImage = 'url(' + graphics[4].src + ')';
	}
	else if( phase > 7000 && o.step == 10 )
	{
		o.step++;
		o.dog.style.backgroundImage = 'url(' + graphics[3].src + ')';
		o.bg.style.opacity = 0;
	}
	else if( phase > 7500 && o.step == 11 )
	{
		o.step++;
		o.dog.style.backgroundImage = 'url(' + graphics[4].src + ')';
	}
	else if( phase > 8000 && o.step == 12 )
	{
		o.step++;
		o.dog.style.backgroundImage = 'url(' + graphics[3].src + ')';
	}
	else if( phase > 8500 && o.step == 13 )
	{
		o.step++;
		o.dog.style.backgroundImage = 'url(' + graphics[4].src + ')';
	}
	else if( phase > 9000 && o.step == 13 )
	{
		o.step++;
		o.dog.style.backgroundImage = 'url(' + graphics[3].src + ')';
	}
	else if( phase > 9500 && o.step == 14 )
	{
		o.step++;
		o.dog.style.backgroundImage = 'url(' + graphics[4].src + ')';
	}
	// End and clean up!
	else if( phase > 11000 && o.step == 15 )
	{
		delete o.dog;
		delete o.bg;
		delete o.logo;
		delete o.pillow;
		o.cleanup();
	}
}

function scene2( o, init )
{
	if( init )
	{
		o.step = 0;
		
		o.timer = ( new Date() ).getTime();
		o.disposables = [];
		
		// Setup background
		var bg = document.createElement( 'div' );
		bg.className = 'background pixelled';
		bg.style.backgroundImage = 'url(' + graphics[7].src + ')';
		bg.style.backgroundRepeat = 'repeat-x';
		bg.style.opacity = 0;
		o.bg = bg;
		bg.stime = ( new Date() ).getTime();
		bg.intr = setInterval( function()
		{
			var move = ( ( new Date() ).getTime() - bg.stime ) / 10;
			bg.style.backgroundPosition = -move + 'px 0px';
		}, 25 );
		screen.appendChild( bg );
		o.disposables.push( bg );
		
		// Setup thge scroller
		var scroller = new Scroller( screen, 0, 5, screen.offsetWidth, 20 );
		scroller.setText( '\
		...... Hello good people, enjoy this little smoked compofiller from your friends in RSE....... ......... ........ ....\
		' );
		scroller.start();
		o.disposables.push( scroller.domElement );
		o.scroller = scroller;
		
		// Create dog
		var dog = document.createElement( 'div' );
		dog.className = 'pixelled dog2';
		dog.style.backgroundImage = 'url(' + graphics[8].src + ')';
		bg.appendChild( dog );
		dog.style.left = '120px';
		dog.style.top = '140px';
		o.dog = dog;
		o.disposables.push( dog );
		
		o.interval = setInterval( function(){ scene2( o ); }, 25 );
		o.cleanup = function()
		{
			clearInterval( this.interval );
			this.interval = false;
		}
		return;		
	}
	
	// We have initialized
	var phase = ( new Date() ).getTime() - o.timer;
	
	// Move the scroller!
	o.scroller.move();
	
	// Dog moves around
	var x = Math.sin( phase / 1000 ) * 50 + 120;
	o.dog.style.left = x + 'px';
	
	// Make sure the background is faded in
	if( o.bg.style.opacity == 0 && o.step == 0 )
	{
		o.bg.style.opacity = 1;
	}
}

function scene3( o, init )
{
	if( init )
	{
		o.step = 0;
		
		o.timer = ( new Date() ).getTime();
		o.disposables = [];
		
		// Setup background
		var bg = document.createElement( 'div' );
		bg.className = 'background pixelled';
		//bg.style.backgroundImage = 'url(' + graphics[7].src + ')';
		//bg.style.backgroundRepeat = 'repeat-x';
		bg.style.opacity = 0;
		o.bg = bg;
		bg.stime = ( new Date() ).getTime();
		/*bg.intr = setInterval( function()
		{
			var move = ( ( new Date() ).getTime() - bg.stime ) / 10;
			bg.style.backgroundPosition = -move + 'px 0px';
		}, 25 );*/
		screen.appendChild( bg );
		o.disposables.push( bg );
		
		/*var scroller = new Scroller( screen, screen.offsetWidth, 100, 0, 0 );
		scroller.setText( '\
		Hello people! This is a scroller made for solskogen 2016...\
		' );
		scroller.start();
		o.disposables.push( scroller.domElement );
		o.scroller = scroller;
		*/
		
		// Create starfield
		var fld = new Starfield( bg );
		o.starField = fld;
		
		// Create dog
		var dog = document.createElement( 'div' );
		dog.className = 'pixelled dog3';
		dog.style.backgroundImage = 'url(' + graphics[9].src + ')';
		bg.appendChild( dog );
		dog.style.left = '-100px';
		dog.style.top = '-100px';
		o.dog = dog;
		o.disposables.push( dog );
		
		o.interval = setInterval( function(){ scene3( o ); }, 25 );
		o.cleanup = function()
		{
			// Clean up star
			for( var a = 0; a < starInfo.stars.length; a++ )
				bg.removeChild( starInfo.stars[a].ele );
			clearInterval( this.interval );
			this.interval = false;
		}
		return;		
	}
	
	// We have initialized
	var phase = ( new Date() ).getTime() - o.timer;
	
	o.starField.move();
	
	// Dog moves around
	var x = Math.sin( phase / 1000 ) * 80;
	var y = Math.cos( phase / 1000 ) * 60;
	x *= Math.cos( phase / 700 ) + 0.3;
	y *= Math.sin( phase / 600 ) + 0.3;
	x += 120; y += 90;
	o.dog.style.left = x + 'px';
	o.dog.style.top  = y + 'px';
	
	// Make sure the background is faded in
	if( o.bg.style.opacity == 0 && o.step == 0 )
	{
		o.bg.style.opacity = 1;
	}
	if( phase > o.time * 1000 )
	{
		o.cleanup();
	}
}

function scene4( o, init )
{
	if( init )
	{
		o.step = 0;
		
		o.timer = ( new Date() ).getTime();
		o.disposables = [];
		
		// Setup background
		var bg = document.createElement( 'div' );
		bg.className = 'background pixelled';
		bg.style.backgroundImage = 'url(' + graphics[10].src + ')';
		bg.style.backgroundRepeat = 'no-repeat';
		bg.style.backgroundPosition = 'center';
		bg.style.opacity = 0;
		o.bg = bg;
		screen.appendChild( bg );
		o.disposables.push( bg );
		
		// Setup thge scroller
		var b = document.createElement( 'div' );
		b.className = 'pixelled';
		bg.appendChild( b );
		var scroller = new Scroller( b, 0, 5, screen.offsetWidth, 20 );
		scroller.setText( '.... graphics and idea: m0ns00n.... music: fjern.... have a great night and sorry for the jerky scroller :) .... .. . . .... .  ' );
		scroller.start();
		o.disposables.push( scroller.domElement );
		o.scroller = scroller;
		
		o.interval = setInterval( function(){ scene4( o ); }, 25 );
		o.cleanup = function()
		{
			clearInterval( this.interval );
			this.interval = false;
		}
		return;
	}
	
	// We have initialized
	var phase = ( new Date() ).getTime() - o.timer;
	
	o.scroller.move();
	
	// Make sure the background is faded in
	if( o.bg.style.opacity == 0 && o.step == 0 )
	{
		o.bg.style.opacity = 1;
	}
	if( phase > ( o.time - 2 ) * 1000 )
	{
		console.log( 'Turn it down' );
		o.bg.style.opacity = 0;
	}
	else if( phase > ( o.time ) * 1000 )
	{
		o.cleanup();
	}
}


