var Rb = function(){
    PartBase.call(this);

    //POSTPROCESSING
    //this.setBloom(0.1);

    var ambientLight = new THREE.AmbientLight(0xffffff);
    this.scene.add(ambientLight);

    this.scene.fog = new THREE.Fog(0x000080, this.near, this.far*0.75);

    //this.texture = TDEMO.TEXTURES.getTextures().kootti2;

    this.rainbow = new Rainbow();
    this.rainbow.rainbowObj.position.set(-50, 0, -300);
    this.rainbow.rainbowObj.rotation.y = Math.PI / 4;
    //this.rainbow.rainbowObj.rotation.x = -Math.PI/4;
    this.scene.add(this.rainbow.rainbowObj);
    console.log(this.rainbow);
    //this.sky = this.createBackground(800, 0x200810, THREE.BackSide);
    this.sky = this.createBackground(800, 0x7090d0, THREE.BackSide);
    this.scene.add(this.sky);

    this.material = new THREE.SpriteMaterial({map : TDEMO.TEXTURES.getTextures().jumalauta});
    this.sprite = new THREE.Sprite(this.material);
    this.sprite.scale.x = 4;
    this.scene.add(this.sprite);

    //this.ground = this.createBackground(1000, 0x200810, THREE.DoubleSide);
    //this.ground.position.y = -1000;
    //this.scene.add(this.ground);
};

Rb.prototype = PartBase.prototype.inheritance();

Rb.prototype.animate = function(elapsedTime, delta){
    PartBase.prototype.animate.call(this, elapsedTime, delta);

    var msin = Math.sin(elapsedTime);
    var mcos = Math.cos(elapsedTime);

    this.rainbow.red.position.set(12*msin, 10*msin, 12*msin);
    this.rainbow.orange.position.set(12*mcos, 10*msin, 12*mcos);
    this.rainbow.yel.position.set(12*msin, 10*msin, 12*mcos);
    this.rainbow.green.position.set(12*mcos, 10*msin, 12*msin);
    this.rainbow.blue.position.set(12*mcos, 10*msin, 12*mcos);
    this.rainbow.v1.position.set(12*mcos, 10*mcos, 12*mcos);
    this.rainbow.v2.position.set(12*msin, 10*mcos, 12*msin);
    /*
    this.rainbow.orange.position.y = 10*Math.cos(elapsedTime);
    this.rainbow.yel.position.y = 11*Math.cos(elapsedTime);
    this.rainbow.green.position.y = 10*Math.sin(elapsedTime);
    this.rainbow.blue.position.y = 9*Math.cos(elapsedTime);
    this.rainbow.v1.position.y = 13*Math.sin(elapsedTime);
    this.rainbow.v2.position.y = 12*Math.cos(elapsedTime);
    */

    var rot = TDEMO.SYNC.getObjRotation();
    this.sprite.rotation.z = rot.z;

    var hb = TDEMO.SYNC.getHeartBeat();
    if(hb > 0){
        this.material.map = TDEMO.TEXTURES.getTextures().paraguay;
        this.material.needsUpdate = true;
    }
    else{
        this.material.map = TDEMO.TEXTURES.getTextures().jumalauta;
        this.material.needsUpdate = true;
    }

};

Rb.prototype.createBackground = function(r, color, side){
    var geometry = new THREE.SphereGeometry(r, 30, 30);
    var material = new THREE.MeshBasicMaterial({
        color : color,
        map : TDEMO.TEXTURES.getTextures().valot,
        side : side
    });

    var bg = new THREE.Mesh(geometry, material);

    return bg;
}
