var Moko = function(){
    PartBase.call(this);

    //POSTPROCESSING

    this.textures = TDEMO.TEXTURES.getTextures();

    var bg = this.createBackground();
    this.scene.add(bg);

    var tiaraMat = new THREE.SpriteMaterial({map : this.textures.tiara});
    this.tiara = new THREE.Sprite(tiaraMat);
    this.tiara.scale.x = 1;
    this.tiara.scale.y = 0.5;
    this.scene.add(this.tiara);

    var kissaMat = new THREE.SpriteMaterial({map : this.textures.kissa_transparent});
    this.kissa = new THREE.Sprite(kissaMat);
    this.kissa.scale.x = 1.5;
    this.kissa.scale.y = 1.5;
    this.kissa.position.y = -0.25;
    this.scene.add(this.kissa);

    this.material = new THREE.SpriteMaterial({map : this.textures.kootti});
    this.gootti = new THREE.Sprite(this.material);
    this.gootti.scale.x = 2;
    this.gootti.scale.y = 2;
    this.scene.add(this.gootti);





};

Moko.prototype = PartBase.prototype.inheritance();

Moko.prototype.animate = function(elapsedTime, delta){
    PartBase.prototype.animate.call(this, elapsedTime, delta);
    this.textures.valot.offset.x += delta*0.01;
    this.textures.valot.offset.x %= 4;

    this.textures.valot.offset.y = 10*Math.sin(delta*0.01);
    this.textures.valot.offset.y %= 4;

    this.textures.valot.needsUpdate = true;

    var hb = TDEMO.SYNC.getHeartBeat();

    if(hb > 0){
        this.material.map = this.textures.kootti2;
        this.material.needsUpdate = true;
    }
    else{
        this.material.map = this.textures.kootti;
        this.material.needsUpdate = true;
    }

    var pos = TDEMO.SYNC.getObjPosition();
    this.kissa.position.x = pos.x;
    this.tiara.position.y = pos.y;

};

Moko.prototype.createBackground = function(){
    var material = new THREE.MeshBasicMaterial({
        map : this.textures.valot,
        side : THREE.DoubleSide
    });
    var geometry = new THREE.PlaneBufferGeometry(400, 200);
    var plane = new THREE.Mesh(geometry, material);
    plane.position.z = -10;
    return plane;
};
