var Kissoj = function(){
    PartBase.call(this);

    //POSTPROCESSING

    this.kissa = TDEMO.TEXTURES.getTextures().kisse;
    var kissaMat = new THREE.SpriteMaterial({map : this.kissa});
    var kissaSprite = new THREE.Sprite(kissaMat);
    kissaSprite.scale.x = 10;
    kissaSprite.scale.y = 10;
    /*kissaSprite.position.y = -1.2;*/
    this.scene.add(kissaSprite);

    var sydamet = TDEMO.TEXTURES.getTextures().hearts_filled;
    var taustaMat = new THREE.SpriteMaterial({map : sydamet});
    this.taustaPlane = this.createScene(sydamet);
    this.taustaPlane.position.z = -200;
    this.scene.add(this.taustaPlane);

};

Kissoj.prototype = PartBase.prototype.inheritance();

Kissoj.prototype.animate = function(elapsedTime, delta){
    PartBase.prototype.animate.call(this, elapsedTime, delta);
    this.kissa.offset.y += delta*0.25;
    this.kissa.offset.y %= 1;
    this.kissa.offset.x -= delta*0.5;
    this.kissa.offset.x %= 4;
    this.kissa.needsUpdate = true;

    var rot = TDEMO.SYNC.getObjRotation();
    this.taustaPlane.rotation.z = rot.z;
};

Kissoj.prototype.createScene = function(map){
    var geometry = new THREE.PlaneBufferGeometry(800, 800);
    var material = new THREE.MeshBasicMaterial({
        map : map,
        color : 0xFF22FF,
        side : THREE.DoubleSide
    });

    var plane = new THREE.Mesh(geometry, material);

    return plane;
}
