var Disko = function(){
    PartBase.call(this);

    //POSTPROCESSING

    this.textures = TDEMO.TEXTURES.getTextures();

    var bg = this.createBackground();
    this.scene.add(bg);

    this.material = new THREE.SpriteMaterial({map : this.textures.diskokootti});
    this.gootti = new THREE.Sprite(this.material);
    this.gootti.scale.x = 2;
    this.gootti.scale.y = 4;
    this.scene.add(this.gootti);

    var kissaMat = new THREE.SpriteMaterial({map : this.textures.kissa_transparent});
    this.kissa = new THREE.Sprite(kissaMat);
    this.kissa.scale.x = 1.5;
    this.kissa.scale.y = 1.5;
    this.kissa.position.y = -1.2;
    this.scene.add(this.kissa);

};

Disko.prototype = PartBase.prototype.inheritance();

Disko.prototype.animate = function(elapsedTime, delta){
    PartBase.prototype.animate.call(this, elapsedTime, delta);
    this.textures.valot.offset.x += delta*0.01;
    this.textures.valot.offset.x %= 4;

    this.textures.valot.offset.y = 10*Math.sin(delta*0.01);
    this.textures.valot.offset.y %= 4;

    this.textures.valot.needsUpdate = true;

    var hb = TDEMO.SYNC.getHeartBeat();

    if(hb > 0){
        this.material.map = this.textures.diskokootti2;
        this.material.needsUpdate = true;
    }
    else{
        this.material.map = this.textures.diskokootti;
        this.material.needsUpdate = true;
    }

    var pos = TDEMO.SYNC.getObjPosition();
    this.kissa.position.x = pos.x;

};

Disko.prototype.createBackground = function(){
    var material = new THREE.MeshBasicMaterial({
        map : this.textures.valot,
        color : 0xFF55FF,
        side : THREE.DoubleSide
    });
    var geometry = new THREE.PlaneBufferGeometry(400, 200);
    var plane = new THREE.Mesh(geometry, material);
    plane.position.z = -10;
    return plane;
};
