var Alku = function(){
    PartBase.call(this);

    //POSTPROCESSING
    this.setBloom(0.2);

    this.texture = TDEMO.TEXTURES.getTextures().hearts_filled;

    this.laatikko = this.createScene(this.texture);
    this.scene.add(this.laatikko);
};

Alku.prototype = PartBase.prototype.inheritance();

Alku.prototype.animate = function(elapsedTime, delta){
    PartBase.prototype.animate.call(this, elapsedTime, delta);
    this.texture.offset.y -= delta*0.5;
    this.texture.offset.y %= 1;

    this.texture.offset.x += delta*0.5;
    this.texture.offset.x %= 4;

    this.texture.needsUpdate = true;

    var rot = TDEMO.SYNC.getObjRotation();
    this.laatikko.rotation.z = rot.z;
    this.laatikko.scale.y = rot.y;
    this.laatikko.scale.x = rot.x;
};

Alku.prototype.createScene = function(map){
    var geometry = new THREE.PlaneBufferGeometry(400, 400);
    var material = new THREE.MeshBasicMaterial({
        map : map//,
        //side : THREE.BackSide
    });

    var tekstuurilaatikko = new THREE.Mesh(geometry, material);

    return tekstuurilaatikko;
}
