#version 120

uniform sampler2D texture;

uniform vec2 direction = vec2(1,0);
uniform int samples = 20;
uniform float spread = 0.004;
uniform float intensity = 0.1;
uniform int showOnlyGlow = 1;
uniform float alpha = 1.0;

vec4 glow()
{
	vec4 sum = vec4(0,0,0,0);
	vec2 coord = gl_TexCoord[0].st;

	for (int i = -samples; i <= samples; i++)
	{
		vec4 texel = texture2D(texture, coord + i * direction * spread);
		sum += texel * (1-abs(float(i))/float(samples)) * texel.a;
	}

	if (showOnlyGlow == 0)
	{
		sum += texture2D(texture, coord);
	}

	sum *= intensity;
	sum.a = alpha;
	
	return sum * gl_Color;
}

void main()
{             
	gl_FragColor = glow();
}
