#!/usr/bin/python
# -*- coding: UTF-8 -*-
import math
from math import sin, cos
import time
import random
import pygame
from pygame.locals import * 

import sys
reload(sys)
sys.setdefaultencoding('utf-8')

pygame.mixer.pre_init(44100, -16, 2, 4096)
pygame.init()
pygame.mixer.init()
pygame.mouse.set_visible(0)
resolution = (1920,1080)
pygame.display.set_caption("Unrelated - Paraguay - Instanssi 2016")
clock = pygame.time.Clock()

# Colors
BLACK = (0,0,0)
WHITE = (255,255,255)
RED = (255,0,0)
GREEN = (0,255,0)
BLUE = (0,0,255)
CYAN = (128,128,255)
PINK = (255,128,128)

screen = pygame.display.set_mode(resolution)
pygame.display.toggle_fullscreen()
surface = pygame.display.get_surface()

bg = pygame.Surface(resolution)
bg = bg.convert()
bg.fill((0,0,0))
darkener = pygame.Surface(resolution)
darkener.fill((0,0,0))
darkener.set_alpha(0)

def sineWave(totalT, startT):
    t = startT-totalT
    global surface
    t = t*200
    w = surface.get_width()
    h = surface.get_height()
    for x in range(0, w):
        y = int((t / 60)*math.sin(((x+t)/(h/2)*(math.pi*2))))+(surface.get_height()/2)
        pygame.draw.circle(surface, WHITE, (x,y), 5)

def plasma(t):
    global surface
    pSize = 30
    t = t
    w = surface.get_width()
    h = surface.get_height()
    C0 = 0.5
    C1 = 0.1
    C2 = 1.0
    C3 = 0.4
    C4 = 0.1
    C5 = 0.7
    for y in range(0,w,pSize):
        for x in range(0,w,pSize):
            r = int((cos(x*C0+sin(C0*t/C3)) - sin(y*C3-cos(t)) + sin(t))%255)
            g = int((cos(y*C1+cos(C1*t/C4)) * sin(x*C4*sin(t)) - cos(t))%255)
            b = int((cos(x*C2+sin(C2*t/C5)) + sin(y*C5+cos(t)) + cos(t))%255)
            pygame.draw.circle(surface, (r,g,b), (x,y), pSize)

def scroller(t, startT, text, x,y, speed = 200):
    global surface
    if(t < startT):
        return
    t = t-startT # Time in effect
    font = pygame.font.SysFont("comicsansms",72)
    txt = font.render(text, True, CYAN)
    overlaybar = pygame.Surface((surface.get_width(), 100))
    overlaybar.fill((0,0,0))
    overlaybar.set_alpha(128)
    surface.blit(overlaybar, (0, y))
    surface.blit(txt, (x-t*speed, y))

STARS = []
MAXSTARS = 500
STARRNG = random.Random()
STARRNG.seed(1234)
def starField(t, startT): # Against all rules of demoeffects, but eh.
    w = surface.get_width()
    h = surface.get_height()
    SPEED = 20
    if(t < startT):
        return
    if(len(STARS) < MAXSTARS):
        STARS.append([w/2, h/2, STARRNG.randrange(0,360)])
        STARS.append([w/2, h/2, STARRNG.randrange(0,360)])
        STARS.append([w/2, h/2, STARRNG.randrange(0,360)])
        STARS.append([w/2, h/2, STARRNG.randrange(0,360)])
        STARS.append([w/2, h/2, STARRNG.randrange(0,360)])
    i = 0
    while(i < len(STARS)):
        STARS[i][0] += int(math.sin((STARS[i][2]*math.pi)/180)*SPEED)
        STARS[i][1] += int(math.cos((STARS[i][2]*math.pi)/180)*SPEED)
        pygame.draw.circle(surface, WHITE, (STARS[i][0], STARS[i][1]), 2)
        if(STARS[i][0] < 0 or STARS[i][1] < 0 or STARS[i][0] > w or STARS[i][1] > h):
            del STARS[i]
            i -= 1
        i += 1
    return

def sceneradio():
    w = surface.get_width()
    h = surface.get_height()
    font = pygame.font.SysFont("comicsansms",72)
    txt = font.render("wappuradio.fi/sceneradio", True, RED)
    surface.blit(txt, (w/2 - txt.get_width()/2, h/2 - txt.get_height()/2))

def timeToPercent(start, stop, now):
    if(now < start):
        return 0
    if(now > stop):
        return 1
    d = stop-start
    t = now-start
    return t/d

pygame.mixer.music.load("final.flac")

startTime = time.time()
pygame.mixer.music.play()

while True:
    elapsed = time.time()-startTime
    screen.blit(bg, (0,0))
    if(elapsed < 25):
        starField(elapsed, 0)
    elif(elapsed < 35):
        plasma(elapsed)
    elif(elapsed < 50):
        sineWave(elapsed, 35)
    elif(elapsed < 55):
        sceneradio()
    elif(elapsed > 55):
        pygame.quit()

    if(elapsed > 15 and elapsed < 25):
        darkener.set_alpha(timeToPercent(15,25,elapsed)*255)
    elif(elapsed >= 25 and elapsed < 30):
        darkener.set_alpha((1-timeToPercent(25,30,elapsed))*255)
    if(elapsed > 30 and elapsed < 35):
        darkener.set_alpha(timeToPercent(30,35,elapsed)*255)
    elif(elapsed >= 35 and elapsed < 40):
        darkener.set_alpha((1-timeToPercent(35,40,elapsed))*255)
    screen.blit(darkener, (0,0))

    if(elapsed < 25):
        scroller(elapsed, 0, u"Moi Instanssi. Compofilleröin koska haluan demottaa kuinka huono idea Sound RNN on. Varokaa silmiä ja korvia", screen.get_width(),screen.get_height()-100, 250)
    elif(elapsed < 35):
        scroller(elapsed, 25, "Greets: W i d e  L o a d, Nalleperhe", screen.get_width(), screen.get_height()-100, 320)
    elif(elapsed < 50):
        scroller(elapsed, 35, u"Nähää ASMeil. --ninnnu & riminAI / Paraguay", screen.get_width(), screen.get_height()-100, 250)
    pygame.display.flip()
    clock.tick(60)
