#version 330 core
in vec2 UV;
out vec4 color;
uniform sampler2D iChannel0; // Blend shader
uniform sampler2D iChannel1; // Src buffer
uniform vec2 iResolution;
uniform float iGlobalTime;
uniform float rotHiha; // 1.2
uniform float scalHiha; // 0.9

mat2 rotate(float a) {
    float c = cos(a);
    float s = sin(a);
    return mat2(c, s, -s, c);
}
vec2 laplacian2(vec2 uv) {
    vec2 val = texture(iChannel0, uv).xy;
    return texture(iChannel0, uv + vec2( 0.0,  1.0) / iResolution.xy).xy +
           texture(iChannel0, uv + vec2( 0.0, -1.0) / iResolution.xy).xy +
           texture(iChannel0, uv + vec2( 1.0,  0.0) / iResolution.xy).xy +
           texture(iChannel0, uv + vec2(-1.0,  0.0) / iResolution.xy).xy -
           4.0 * val;
}

void main()
{
  vec2 uv = UV;
    float Da = 0.13;        // Parameters
    float Db = 0.1;         // Parameters
    float K = 0.055;        // Parameters
    float F = 0.0645;       // Parameters
    vec2 val = texture(iChannel0, uv).xy;
    vec4 df = vec4(0.0);
    df.xy = vec2(Da * laplacian2(uv).x - val.x*val.y*val.y + F * (1.0 - val.x),
                 Db * laplacian2(uv).y + val.x*val.y*val.y - (K+F)*val.y);
    df.zw = vec2(0.0);
    vec4 newval = texture(iChannel0, uv) + df * 2.0;  // 2.0 is very sensitive time discretization constant
  vec4 oldval = texture(iChannel1, scalHiha * rotate(rotHiha * 3.141 / 180.0) * (uv - vec2(0.5)) + vec2(0.5));

    float a = 0.925;
    color = a * newval + (1.0 - a) * oldval;
    color.a = 1.0;
    color = vec4(smoothstep(vec3(-0.1), vec3(1.01), color.xyz), 1.0); // Avoid fuck uppage
}
