#version 330 core
in vec2 UV;
out vec4 color;
uniform sampler2D iChannel0; // Video
uniform sampler2D iChannel1; // Src buffer
uniform float iGlobalTime;
uniform float wmax; // weight of src buffer. approx 0.97

float rand(vec2 co){
    return fract(sin(dot(co.xy ,vec2(12.9898,78.233))) * 43758.5453);
}

void main(){
  vec2 uv = UV;
    float w = wmax * smoothstep(0.2, 1.2, iGlobalTime); // Ensure something on beginning
    float a = 0.85;
    vec4 randv = vec4(
       rand(UV + iGlobalTime),
       rand(UV.yx - iGlobalTime),
       rand(UV.xx + vec2(iGlobalTime, 0.0)),
       rand(UV.yx - vec2(0.0, iGlobalTime))
      );
    color = w * texture(iChannel1, uv) + 
        (1.0 - w) * (a * texture(iChannel0, uv) + (1.0 - a)*randv);
}